/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.model;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.string.StringTools;

public class IconDefinition
implements IElementConfigurable,
IElementSerializable {
    private String css;
    private String descriptor;

    public static IconDefinition create(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String string = (String)value;
            return new IconDefinition(string);
        }
        if (value instanceof IconDefinition) {
            IconDefinition id = (IconDefinition)value;
            return id;
        }
        return new IconDefinition(String.valueOf(value));
    }

    public IconDefinition() {
    }

    public IconDefinition(String descriptor) {
        this.descriptor = descriptor;
    }

    public void configure(IElement element) throws ConfigurationException {
        this.css = ElementTools.getString((IElement)element, (String)"css", null);
        this.descriptor = ElementTools.getString((IElement)element, (String)"descriptor", null);
    }

    public IconDefinition copyDeep() {
        IconDefinition copy = new IconDefinition();
        copy.css = this.css;
        copy.descriptor = this.descriptor;
        return copy;
    }

    public String getCss() {
        return this.css;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public boolean isPrimitive() {
        return StringTools.isEmpty((String)this.css);
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("css", this.css);
        element.setAttributeValue("descriptor", this.descriptor);
    }

    public void setCss(String css) {
        this.css = css;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }
}

