/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.model;

import de.intarsys.tools.action.ActionProxy;
import de.intarsys.tools.action.ActionRegistry;
import de.intarsys.tools.action.IAction;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.FunctorMethodHandler;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.IMessageBundleSupport;
import de.intarsys.tools.message.MessageTools;
import de.intarsys.tools.reflect.IClassLoaderSupport;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.widget.model.ActionSpec;
import de.intarsys.widget.model.IWidgetDefinition;
import de.intarsys.widget.model.IWidgetDefinitionContainer;
import de.intarsys.widget.model.IWidgetDefinitionFactory;
import de.intarsys.widget.model.WidgetDefinition;
import de.intarsys.widget.model.WidgetDefinitionContainer;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardWidgetDefinitionFactory
implements IWidgetDefinitionFactory,
IClassLoaderSupport {
    private static final Logger Log = LoggerFactory.getLogger(StandardWidgetDefinitionFactory.class);
    private Object context;
    private IMessageBundle messageBundle;
    private final IWidgetDefinitionContainer widgetDefinitionRegistry;

    public StandardWidgetDefinitionFactory() {
        this(new WidgetDefinitionContainer());
    }

    public StandardWidgetDefinitionFactory(IWidgetDefinitionContainer widgetDefinitionRegistry) {
        this.widgetDefinitionRegistry = widgetDefinitionRegistry;
    }

    protected void createEventHandler(IWidgetDefinition definition, IElement eventElement) {
        try {
            String eventId = eventElement.attributeValue("event", null);
            if (eventId != null) {
                String actionId = eventElement.attributeValue("action", null);
                if (actionId != null) {
                    IAction action = ActionRegistry.get().lookupAction(actionId);
                    if (action == null) {
                        Log.warn("widget '" + definition.getId() + "' action '" + actionId + "' is proxy");
                        action = new ActionProxy(actionId, ActionRegistry.get());
                    }
                    WidgetDefinition.setSelectCallbackAction(definition, action);
                } else {
                    IFunctor functor = ElementTools.createFunctor((Object)definition, (IElement)eventElement, null, (Object)this);
                    definition.setCallback(eventId, FunctorMethodHandler.create((IFunctor)functor));
                }
            }
        }
        catch (ObjectCreationException e) {
            Log.warn("widget '" + definition.getId() + "' error creating functor ", (Throwable)e);
        }
    }

    protected void createProperty(WidgetDefinition definition, IElement propertyElement) {
        try {
            String propertyId = propertyElement.getName();
            if (propertyId != null) {
                IFunctor functor = ElementTools.createFunctor((Object)definition, (IElement)propertyElement, null, (Object)this.getContext());
                definition.setValue(propertyId, FunctorMethodHandler.create((IFunctor)functor));
            }
        }
        catch (ObjectCreationException e) {
            Log.warn("widget '{}' error creating functor ", (Object)definition.getId(), (Object)e);
        }
    }

    @Override
    public IWidgetDefinition createWidgetDefinition(IWidgetDefinition parent, IElement element) throws ObjectCreationException {
        IElement eventElement;
        String id = element.attributeValue("id", null);
        WidgetDefinition widget = new WidgetDefinition(parent, id);
        widget.setFactory(this);
        try {
            widget.configure(element);
        }
        catch (Exception e) {
            throw (ObjectCreationException)ExceptionTools.unwrapTyped((Throwable)e, ObjectCreationException.class);
        }
        Iterator itAll = element.elementIterator();
        while (itAll.hasNext()) {
            IElement eventElement2 = (IElement)itAll.next();
            String eventName = eventElement2.getName();
            if (eventName == null || !eventName.startsWith("on-") || eventName.length() <= 3) continue;
            String callbackName = eventName.substring(3);
            ActionSpec actionSpec = ActionSpec.build(eventElement2);
            widget.setCallback(callbackName, actionSpec);
        }
        IElement callbacks = element.element("callbacks");
        if (callbacks != null) {
            Iterator itCallbacks = callbacks.elementIterator();
            while (itCallbacks.hasNext()) {
                eventElement = (IElement)itCallbacks.next();
                String callbackName = eventElement.getName();
                ActionSpec actionSpec = ActionSpec.build(eventElement);
                widget.setCallback(callbackName, actionSpec);
            }
        }
        Iterator itOn = element.elementIterator("on");
        while (itOn.hasNext()) {
            eventElement = (IElement)itOn.next();
            this.createEventHandler(widget, eventElement);
        }
        IElement visible = element.element("visible");
        if (visible != null) {
            this.createProperty(widget, visible);
        }
        if (parent == null) {
            this.getWidgetDefinitionRegistry().addWidgetDefinition(widget);
        }
        try {
            ElementTools.setProperties((Object)widget, (IElement)element, (Object)this.getClassLoader());
        }
        catch (Exception e) {
            throw (ObjectCreationException)ExceptionTools.unwrapTyped((Throwable)e, ObjectCreationException.class);
        }
        return widget;
    }

    public ClassLoader getClassLoader() {
        if (this.context instanceof IClassLoaderSupport) {
            return ((IClassLoaderSupport)this.context).getClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    public Object getContext() {
        return this.context;
    }

    public IMessageBundle getMessageBundle() {
        return this.messageBundle;
    }

    public IWidgetDefinitionContainer getWidgetDefinitionRegistry() {
        return this.widgetDefinitionRegistry;
    }

    public void setContext(Object context) throws ConfigurationException {
        this.context = context;
        if (context instanceof IMessageBundleSupport) {
            this.setMessageBundle(((IMessageBundleSupport)context).getMessageBundle());
        } else {
            this.setMessageBundle(MessageTools.getMessageBundle(this.getClass()));
        }
    }

    public void setMessageBundle(IMessageBundle bundle) {
        this.messageBundle = bundle;
    }
}

