/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.model;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.LiteralMessage;
import de.intarsys.tools.string.StringTools;

public class StyledTextDefinition
implements IElementConfigurable,
IElementSerializable {
    private String css;
    private IMessage message;

    public static StyledTextDefinition create(Object value) {
        String labelString;
        if (value instanceof String && (labelString = (String)value).startsWith("${nls")) {
            try {
                value = TemplateEvaluator.get((Mode)Mode.UNTRUSTED).evaluate(labelString, (IArgs)Args.create());
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        if (value == null) {
            return null;
        }
        if (value instanceof StyledTextDefinition) {
            return (StyledTextDefinition)value;
        }
        if (value instanceof IMessage) {
            return new StyledTextDefinition((IMessage)value);
        }
        return new StyledTextDefinition(String.valueOf(value));
    }

    public StyledTextDefinition() {
    }

    public StyledTextDefinition(IMessage message) {
        this.message = message;
    }

    public StyledTextDefinition(String messageString) {
        this.setMessageString(messageString);
    }

    public void configure(IElement element) throws ConfigurationException {
        this.css = ElementTools.getString((IElement)element, (String)"css", null);
        this.setMessageString(ElementTools.getString((IElement)element, (String)"message", null));
    }

    public StyledTextDefinition copyDeep() {
        StyledTextDefinition copy = new StyledTextDefinition();
        copy.css = this.css;
        copy.message = this.message;
        return copy;
    }

    public String getCss() {
        return this.css;
    }

    public IMessage getMessage() {
        return this.message;
    }

    public String getMessageString() {
        return this.message == null ? null : this.message.getString();
    }

    public boolean isPrimitive() {
        return StringTools.isEmpty((String)this.css);
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("css", this.css);
        if (this.message != null) {
            element.setAttributeValue("message", this.message.getString());
        }
    }

    public void setCss(String css) {
        this.css = css;
    }

    public void setMessage(IMessage message) {
        this.message = message;
    }

    public void setMessageString(String messageString) {
        this.message = LiteralMessage.create((String)messageString.replace("{", "'{'"));
    }
}

