/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.model;

import de.intarsys.tools.action.ActionCheckedFieldHandler;
import de.intarsys.tools.action.ActionMethodHandler;
import de.intarsys.tools.action.IAction;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.exception.UnreachableCodeError;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.FunctorMethodHandler;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.functor.IFunctorCallFactory;
import de.intarsys.tools.functor.SimpleFunctorCallFactory;
import de.intarsys.tools.infoset.ArgsElementAdapter;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.lang.ICopyDeep;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IBasicAccessSupport;
import de.intarsys.tools.reflect.IClassLoaderSupport;
import de.intarsys.tools.reflect.IMethodHandler;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import de.intarsys.widget.common.WidgetTools;
import de.intarsys.widget.model.CommonWidgetDefinitionContainer;
import de.intarsys.widget.model.ICallbackSupport;
import de.intarsys.widget.model.IWidgetDefinition;
import de.intarsys.widget.model.IWidgetDefinitionContainerVisitor;
import de.intarsys.widget.model.IWidgetDefinitionFactory;
import de.intarsys.widget.model.IWidgetDefinitionVisitor;
import de.intarsys.widget.model.IconDefinition;
import de.intarsys.widget.model.StandardWidgetDefinitionFactory;
import de.intarsys.widget.model.StyledTextDefinition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class WidgetDefinition
extends CommonWidgetDefinitionContainer
implements IWidgetDefinition,
ICallbackSupport,
IClassLoaderSupport,
IBasicAccessSupport,
IFunctorCallFactory,
IElementConfigurable,
IElementSerializable,
ICopyDeep {
    private static IFunctorCallFactory DefaultFunctorCallFactory = new SimpleFunctorCallFactory();
    private Map<String, IMethodHandler> callbacks;
    private Object description = null;
    private IWidgetDefinitionFactory factory;
    private IFunctorCallFactory functorCallFactory;
    private IconDefinition icon;
    private String id;
    private StyledTextDefinition label;
    private IWidgetDefinition parent;
    private String parentName;
    private Map<String, Object> properties;
    private String registerName;
    private String style;
    private Object tip = null;
    private String type;

    public static Builder builder() {
        return new Builder(null);
    }

    public static Builder builder(WidgetDefinition target) {
        if (target == null) {
            throw new NullPointerException("target cannot be null");
        }
        return new Builder(null, target);
    }

    public static WidgetDefinition create(IWidgetDefinition parent, IAction action) {
        WidgetDefinition result = new WidgetDefinition(parent, action.getId());
        WidgetDefinition.setSelectCallbackAction(result, action);
        return result;
    }

    public static WidgetDefinition fromArgs(IArgs args) {
        if (args == null || args.size() == 0) {
            return null;
        }
        WidgetDefinition result = new WidgetDefinition();
        result.setFactory(new StandardWidgetDefinitionFactory());
        try {
            result.configure((IElement)new ArgsElementAdapter(args));
        }
        catch (Exception ex) {
            throw new UnreachableCodeError((Throwable)ex);
        }
        WidgetTools.defineCallbacks(result, args);
        IArgs argsProperties = ArgTools.getArgs((IArgs)args, (String)"properties", null);
        if (argsProperties != null) {
            for (IArgs.IBinding binding : argsProperties) {
                result.setValue(binding.getName(), binding.getValue());
            }
        }
        return result;
    }

    public static List<WidgetDefinition> fromArgsList(IArgs args) {
        if (args == null) {
            return Collections.emptyList();
        }
        return WidgetDefinition.fromArgsList(StreamSupport.stream(args.spliterator(), false));
    }

    public static List<WidgetDefinition> fromArgsList(Stream<IArgs.IBinding> stream) {
        return stream.map(binding -> WidgetDefinition.fromArgs(ArgTools.toArgs((Object)binding.getValue()))).toList();
    }

    public static IFunctorCallFactory getDefaultFunctorCallFactory() {
        return DefaultFunctorCallFactory;
    }

    public static String getString(Object message) {
        if (message == null) {
            return null;
        }
        if (message instanceof StyledTextDefinition) {
            return ((StyledTextDefinition)message).getMessageString();
        }
        if (message instanceof IMessage) {
            return ((IMessage)message).getString();
        }
        return String.valueOf(message);
    }

    public static void setDefaultFunctorCallFactory(IFunctorCallFactory defaultFunctorCallFactory) {
        DefaultFunctorCallFactory = defaultFunctorCallFactory;
    }

    public static void setSelectCallbackAction(IWidgetDefinition definition, IAction action) {
        IMethodHandler handler = ActionMethodHandler.create((IAction)action);
        definition.setCallback("select", handler);
        if (action.isCheckStyle()) {
            definition.addStyle("check");
            try {
                definition.setValue("checked", new ActionCheckedFieldHandler(action));
            }
            catch (FieldException fieldException) {
                // empty catch block
            }
        }
    }

    public WidgetDefinition() {
        this(null, null, null);
    }

    public WidgetDefinition(IWidgetDefinition parent) {
        this(parent, null, null);
    }

    public WidgetDefinition(IWidgetDefinition parent, String pId) {
        this(parent, pId, null);
    }

    public WidgetDefinition(IWidgetDefinition parent, String pId, String type) {
        this.id = pId;
        this.setType(type);
        if (parent != null) {
            parent.addWidgetDefinition(this);
        }
    }

    @Override
    public Object accept(IWidgetDefinitionContainerVisitor visitor) {
        return visitor.visitWidgetDefinitionContainer(this);
    }

    @Override
    public Object accept(IWidgetDefinitionVisitor visitor) {
        return visitor.visitWidgetDefinition(this);
    }

    @Override
    public void addStyle(String pStyle) {
        this.style = this.style == null ? pStyle : this.style + "; " + pStyle;
    }

    @Override
    public void addWidgetDefinition(IWidgetDefinition child) {
        super.addWidgetDefinition(child);
        child.setParent(this);
    }

    public Object basicGetValue(String name) throws FieldException {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public Object basicSetValue(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties.put(name, value);
    }

    public void configure(IElement element) throws ConfigurationException {
        try {
            IElement elChild;
            Iterator itChildren;
            this.setId(element.attributeValue("id", null));
            this.setParentName(element.attributeValue("parent", null));
            this.setRegisterName(element.attributeValue("register", null));
            this.setType(element.attributeValue("type", null));
            this.setStyle(element.attributeValue("style", null));
            StyledTextDefinition label = (StyledTextDefinition)ElementTools.getObject((IElement)element, (String)"extendedLabel", StyledTextDefinition.class);
            if (label == null) {
                label = (StyledTextDefinition)ElementTools.getObject((IElement)element, (String)"label", StyledTextDefinition.class);
            }
            this.setLabelDefinition(label);
            this.setTip(ElementTools.getObject((IElement)element, (String)"tip", Object.class));
            this.setDescription(ElementTools.getObject((IElement)element, (String)"description", Object.class));
            IconDefinition iconDefinition = (IconDefinition)ElementTools.getObject((IElement)element, (String)"extendedIcon", IconDefinition.class);
            if (iconDefinition == null) {
                iconDefinition = (IconDefinition)ElementTools.getObject((IElement)element, (String)"icon", IconDefinition.class);
            }
            this.setIcon(iconDefinition);
            this.setComposite(ElementTools.getBoolean((IElement)element, (String)"composite", (boolean)false));
            IElement elChildren = element.element("children");
            if (elChildren != null) {
                itChildren = elChildren.elementIterator();
                while (itChildren.hasNext()) {
                    elChild = (IElement)itChildren.next();
                    this.getFactory().createWidgetDefinition(this, elChild);
                }
            }
            itChildren = element.elementIterator("widget");
            while (itChildren.hasNext()) {
                elChild = (IElement)itChildren.next();
                this.getFactory().createWidgetDefinition(this, elChild);
            }
        }
        catch (Exception e) {
            throw (ConfigurationException)ExceptionTools.unwrapTyped((Throwable)e, ConfigurationException.class);
        }
    }

    public WidgetDefinition copyDeep() {
        WidgetDefinition result = new WidgetDefinition();
        this.copyDeep(result);
        return result;
    }

    protected void copyDeep(WidgetDefinition result) {
        super.copyDeep(result);
        result.callbacks = (Map)LangTools.copyDeep(this.callbacks);
        result.description = this.description;
        result.factory = this.factory;
        result.functorCallFactory = this.functorCallFactory;
        result.icon = this.icon == null ? null : this.icon.copyDeep();
        result.id = this.id;
        result.parentName = this.getParentName();
        result.label = this.label == null ? null : this.label.copyDeep();
        result.properties = (Map)LangTools.copyDeep(this.properties);
        result.registerName = this.registerName;
        result.style = this.style;
        result.tip = this.tip;
        result.type = this.type;
    }

    public IFunctorCall createFunctorCall(IFunctor functor, Object receiver, IArgs args) throws ObjectCreationException {
        return this.getFunctorCallFactory().createFunctorCall(functor, receiver, args);
    }

    @Override
    public void dispose() {
        if (this.getParent() != null) {
            this.getParent().removeWidgetDefinition(this);
        }
    }

    @Override
    public IMethodHandler getCallback(String name) {
        if (this.callbacks == null) {
            return null;
        }
        return this.callbacks.get(name);
    }

    @Override
    public Map<String, IMethodHandler> getCallbacks() {
        if (this.callbacks == null) {
            return Collections.emptyMap();
        }
        return this.callbacks;
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader result = null;
        if (this.getFactory() instanceof IClassLoaderSupport) {
            result = ((IClassLoaderSupport)this.getFactory()).getClassLoader();
        }
        if (result == null) {
            result = this.getClass().getClassLoader();
        }
        return result;
    }

    protected IMethodHandler getDefaultCallback() {
        if (this.callbacks == null) {
            return null;
        }
        return this.callbacks.get("select");
    }

    protected String getDefaultDescription() {
        IMethodHandler defaultCallback = this.getDefaultCallback();
        if (defaultCallback instanceof IPresentationSupport) {
            return ((IPresentationSupport)defaultCallback).getDescription();
        }
        return this.getTip();
    }

    protected String getDefaultIconName() {
        IMethodHandler defaultCallback = this.getDefaultCallback();
        if (defaultCallback instanceof IPresentationSupport) {
            return ((IPresentationSupport)defaultCallback).getIconName();
        }
        return null;
    }

    protected String getDefaultLabel() {
        IMethodHandler defaultCallback = this.getDefaultCallback();
        if (defaultCallback instanceof IPresentationSupport) {
            return ((IPresentationSupport)defaultCallback).getLabel();
        }
        return this.getId();
    }

    protected String getDefaultTip() {
        IMethodHandler defaultCallback = this.getDefaultCallback();
        if (defaultCallback instanceof IPresentationSupport) {
            return ((IPresentationSupport)defaultCallback).getTip();
        }
        return this.getLabel();
    }

    public String getDescription() {
        if (this.description == null) {
            return this.getDefaultDescription();
        }
        if (this.description instanceof IMessage) {
            return ((IMessage)this.description).getString();
        }
        return (String)this.description;
    }

    public Object getDescriptionRaw() {
        return this.description;
    }

    @Override
    public IWidgetDefinitionFactory getFactory() {
        return this.factory;
    }

    public IFunctorCallFactory getFunctorCallFactory() {
        if (this.functorCallFactory == null) {
            if (this.getParent() != null) {
                return ((WidgetDefinition)this.getParent()).getFunctorCallFactory();
            }
            return WidgetDefinition.getDefaultFunctorCallFactory();
        }
        return this.functorCallFactory;
    }

    public IconDefinition getIcon() {
        return this.icon;
    }

    public String getIconName() {
        if (this.icon == null) {
            return this.getDefaultIconName();
        }
        return this.icon.getDescriptor();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getDefaultLabel();
        }
        return WidgetDefinition.getString(this.label);
    }

    public StyledTextDefinition getLabelDefinition() {
        return this.label;
    }

    @Override
    public IWidgetDefinition getParent() {
        return this.parent;
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public String getPath() {
        String path = null;
        for (IWidgetDefinition def = this; def != null; def = def.getParent()) {
            if (def.getRegisterName() != null) {
                path = path == null ? def.getRegisterName() : def.getRegisterName() + "/" + path;
                break;
            }
            path = path == null ? def.getId() : def.getId() + "/" + path;
        }
        return path;
    }

    @Override
    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    public String getRegister() {
        return this.registerName;
    }

    @Override
    public String getRegisterName() {
        return this.registerName;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    public String getTip() {
        if (this.tip == null) {
            return this.getDefaultTip();
        }
        if (this.tip instanceof IMessage) {
            return ((IMessage)this.tip).getString();
        }
        return (String)this.tip;
    }

    public Object getTipRaw() {
        return this.tip;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public Object getValue(String propertyName) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(propertyName);
    }

    @Override
    public boolean isStyle(String styleFlag) {
        return this.style != null && this.style.indexOf(styleFlag) != -1;
    }

    @Override
    protected boolean matchesChild(IWidgetDefinition child, String childId) {
        return childId.equals(child.getId());
    }

    @Override
    public void removeWidgetDefinition(IWidgetDefinition component) {
        super.removeWidgetDefinition(component);
        component.setParent(null);
    }

    public void serialize(IElement element) throws ElementSerializationException {
        IElement elContainer;
        element.setAttributeValue("id", this.id);
        element.setAttributeValue("parent", this.parentName);
        element.setAttributeValue("register", this.registerName);
        element.setAttributeValue("type", this.type);
        element.setAttributeValue("style", this.getStyle());
        if (this.label != null) {
            element.setAttributeValue("label", WidgetDefinition.getString(this.label));
            if (!this.label.isPrimitive()) {
                IElement labelElement = element.newElementMapped("extendedLabel");
                this.label.serialize(labelElement);
            }
        }
        element.setAttributeValue("tip", WidgetDefinition.getString(this.tip));
        element.setAttributeValue("description", WidgetDefinition.getString(this.description));
        if (this.icon != null) {
            element.setAttributeValue("icon", this.icon.getDescriptor());
            if (!this.icon.isPrimitive()) {
                IElement iconElement = element.newElementMapped("extendedIcon");
                this.icon.serialize(iconElement);
            }
        }
        if (this.getChildren() != null) {
            elContainer = element.newElementIndexed("children");
            for (IWidgetDefinition iWidgetDefinition : this.getChildren()) {
                ElementTools.putObject((IElement)elContainer, (String)"widget", (Object)iWidgetDefinition);
            }
        }
        if (this.getCallbacks().size() > 0) {
            elContainer = element.newElementMapped("callbacks");
            for (Map.Entry entry : this.getCallbacks().entrySet()) {
                ElementTools.putObject((IElement)elContainer, (String)((String)entry.getKey()), entry.getValue());
            }
        }
        if (this.getProperties().size() > 0) {
            elContainer = element.newElementMapped("properties");
            for (Map.Entry entry : this.getProperties().entrySet()) {
                ElementTools.putObject((IElement)elContainer, (String)((String)entry.getKey()), entry.getValue());
            }
        }
    }

    @Override
    public void setCallback(String eventName, IMethodHandler callback) {
        if (callback == null) {
            return;
        }
        if (this.callbacks == null) {
            this.callbacks = new HashMap<String, IMethodHandler>();
        }
        this.callbacks.put(eventName, callback);
    }

    public void setCallback(String event, Object value) {
        if (value instanceof IMethodHandler) {
            this.setCallback(event, (IMethodHandler)value);
        } else if (value instanceof IFunctor) {
            this.setCallback(event, FunctorMethodHandler.create((IFunctor)((IFunctor)value)));
        } else {
            throw new IllegalArgumentException("callback '" + value + "' not supported");
        }
    }

    public void setCallbacks(Map<String, ?> callbacks) {
        for (Map.Entry<String, ?> entry : callbacks.entrySet()) {
            String event = entry.getKey();
            Object value = entry.getValue();
            this.setCallback(event, value);
        }
    }

    @Override
    public void setChildren(List<IWidgetDefinition> children) {
        super.setChildren(children);
        if (children != null) {
            for (IWidgetDefinition child : children) {
                child.setParent(this);
            }
        }
    }

    public void setDescription(Object value) {
        this.description = value;
    }

    public void setFactory(IWidgetDefinitionFactory factory) {
        this.factory = factory;
    }

    public void setFunctorCallFactory(IFunctorCallFactory functorCallFactory) {
        this.functorCallFactory = functorCallFactory;
    }

    public void setIcon(IconDefinition icon) {
        this.icon = icon;
    }

    public void setIconName(String iconName) {
        this.icon = StringTools.isEmpty((String)iconName) ? null : new IconDefinition(iconName);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(String value) {
        this.setLabelDefinition(StyledTextDefinition.create(value));
    }

    public void setLabelDefinition(StyledTextDefinition label) {
        this.label = label;
    }

    public void setLabelRaw(Object value) {
        this.setLabelDefinition(StyledTextDefinition.create(value));
    }

    @Override
    public void setParent(IWidgetDefinition parent) {
        this.parent = parent;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setRegister(String alias) {
        this.registerName = alias;
    }

    public void setRegisterName(String alias) {
        this.registerName = alias;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setTip(Object value) {
        this.tip = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object setValue(String propertyName, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties.put(propertyName, value);
    }

    public String toString() {
        return "Widget " + this.getId() + "@" + this.getParentName();
    }

    public static class Builder {
        private Builder parent;
        private WidgetDefinition widgetDefinition;

        public Builder(Builder parent) {
            this.parent = parent;
            this.widgetDefinition = new WidgetDefinition();
            this.widgetDefinition.setFactory(new StandardWidgetDefinitionFactory());
        }

        public Builder(Builder parent, WidgetDefinition target) {
            this.parent = parent;
            this.widgetDefinition = target;
        }

        public WidgetDefinition build() {
            return this.widgetDefinition;
        }

        public Builder callback(String name, Object callback) {
            return this.on(name, callback);
        }

        public Builder child() {
            Builder childBuilder = new Builder(this);
            return childBuilder;
        }

        public Builder child(String id) {
            Builder childBuilder = new Builder(this);
            childBuilder.id(id);
            return childBuilder;
        }

        public Builder end() {
            if (this.parent == null) {
                throw new IllegalStateException("no parent");
            }
            this.parent.widgetDefinition.addWidgetDefinition(this.widgetDefinition);
            return this.parent;
        }

        public Builder icon(String string) {
            this.widgetDefinition.setIconName(string);
            return this;
        }

        public Builder id(String id) {
            this.widgetDefinition.setId(id);
            return this;
        }

        public Builder label(String string) {
            this.widgetDefinition.setLabel(string);
            return this;
        }

        public Builder on(String name, Object callback) {
            this.widgetDefinition.setCallback(name, callback);
            return this;
        }

        public Builder parentName(String id) {
            this.widgetDefinition.setParentName(id);
            return this;
        }

        public Builder property(String name, Object value) {
            this.widgetDefinition.basicSetValue(name, value);
            return this;
        }

        public Builder registerName(String id) {
            this.widgetDefinition.setRegisterName(id);
            return this;
        }

        public Builder type(String type) {
            this.widgetDefinition.setType(type);
            return this;
        }
    }
}

