/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.widget.model;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.functor.IFunctorCallFactory;
import de.intarsys.tools.reflect.FieldAccessException;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IFieldHandler;
import de.intarsys.tools.reflect.IMethodHandler;
import de.intarsys.tools.reflect.IMethodHandlerAccessibility;
import de.intarsys.tools.reflect.InvokeAccept;
import de.intarsys.tools.reflect.InvokeIntercept;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.widget.common.CommonWidgetItemFactory;
import de.intarsys.widget.model.IWidgetDefinition;
import de.intarsys.widget.model.IWidgetItem;
import de.intarsys.widget.model.IWidgetItemFactory;
import de.intarsys.widget.model.IWidgetItemVisitor;
import java.util.Map;

public class WidgetItem
implements IWidgetItem,
IFunctorCallFactory {
    private static final IWidgetItem[] EMPTY = new IWidgetItem[0];
    private AttributeMap attributes;
    private IWidgetItem[] children;
    private int childrenIndex = 0;
    private final IWidgetDefinition definition;
    private boolean disposed = false;
    private EventDispatcher dispatcher;
    private final CommonWidgetItemFactory factory;
    private Object impl;
    private final INotificationListener listenChange = new INotificationListener(){

        public void handleEvent(Event event) {
            Object attribute = ((AttributeChangedEvent)event).getAttribute();
            WidgetItem.this.triggerChange(attribute, null, null);
        }
    };
    private final IWidgetItem parent;
    private int redraw = 0;
    private boolean updateNotify = false;
    private boolean visible = true;

    public WidgetItem(CommonWidgetItemFactory factory, IWidgetDefinition definition, IWidgetItem parent) {
        this(factory, definition, parent, null);
    }

    public WidgetItem(CommonWidgetItemFactory factory, IWidgetDefinition definition, IWidgetItem parent, Object impl) {
        this.factory = factory;
        this.parent = parent;
        this.definition = definition;
        this.impl = impl;
        if (parent != null) {
            parent.addWidgetItem(this);
        }
        this.arm();
    }

    @Override
    public Object accept(IWidgetItemVisitor visitor) {
        return visitor.visitWidgetItem(this);
    }

    public synchronized void addNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher((Object)this);
        }
        this.dispatcher.addNotificationListener(type, listener);
    }

    @Override
    public void addWidgetItem(IWidgetItem item) {
        if (this.children == null) {
            this.children = new IWidgetItem[5];
        } else if (this.childrenIndex >= this.children.length) {
            IWidgetItem[] tempChildren = new IWidgetItem[this.children.length + 5];
            System.arraycopy(this.children, 0, tempChildren, 0, this.children.length);
            this.children = tempChildren;
        }
        this.children[this.childrenIndex++] = item;
        IWidgetDefinition tempDefinition = item.getWidgetDefinition();
        if (tempDefinition == null) {
            return;
        }
    }

    protected void arm() {
        if (this.getWidgetDefinition() == null) {
            return;
        }
        Map<String, IMethodHandler> callbacks = this.getWidgetDefinition().getCallbacks();
        if (callbacks != null) {
            for (IMethodHandler iMethodHandler : callbacks.values()) {
                if (!(iMethodHandler instanceof INotificationSupport)) continue;
                ((INotificationSupport)iMethodHandler).addNotificationListener(AttributeChangedEvent.ID, this.listenChange);
            }
        }
        for (Map.Entry entry : this.getWidgetDefinition().getProperties().entrySet()) {
            Object property = entry.getValue();
            if (!(property instanceof INotificationSupport)) continue;
            ((INotificationSupport)property).addNotificationListener(AttributeChangedEvent.ID, this.listenChange);
        }
    }

    protected synchronized IWidgetItem basicGetWidgetItem(String childId) {
        for (int i = 0; i < this.childrenIndex; ++i) {
            IWidgetItem childItem = this.children[i];
            IWidgetDefinition childDefinition = childItem.getWidgetDefinition();
            if (!childId.equals(childDefinition.getId())) continue;
            return childItem;
        }
        return null;
    }

    public IFunctorCall createFunctorCall(IFunctor functor, Object receiver, IArgs args) throws ObjectCreationException {
        return ((IFunctorCallFactory)this.definition).createFunctorCall(functor, receiver, args);
    }

    @Override
    public void disableUpdatePropagation() {
        ++this.redraw;
        if (this.children != null) {
            for (int i = 0; i < this.childrenIndex; ++i) {
                IWidgetItem child = this.children[i];
                child.disableUpdatePropagation();
            }
        }
    }

    protected void disarm() {
        if (this.getWidgetDefinition() == null) {
            return;
        }
        Map<String, IMethodHandler> callbacks = this.getWidgetDefinition().getCallbacks();
        if (callbacks != null) {
            for (IMethodHandler iMethodHandler : callbacks.values()) {
                if (!(iMethodHandler instanceof INotificationSupport)) continue;
                ((INotificationSupport)iMethodHandler).removeNotificationListener(AttributeChangedEvent.ID, this.listenChange);
            }
        }
        for (Map.Entry entry : this.getWidgetDefinition().getProperties().entrySet()) {
            Object property = entry.getValue();
            if (!(property instanceof INotificationSupport)) continue;
            ((INotificationSupport)property).removeNotificationListener(AttributeChangedEvent.ID, this.listenChange);
        }
    }

    @Override
    public void dispose() {
        IWidgetItem[] tempChildren;
        if (this.disposed) {
            return;
        }
        this.disarm();
        this.factory.fromWidgetItemDispose(this);
        if (this.getParent() != null) {
            this.getParent().removeWidgetItem(this);
        }
        if ((tempChildren = this.getWidgetItems()) != null) {
            for (int i = 0; i < this.childrenIndex; ++i) {
                IWidgetItem child = tempChildren[i];
                child.dispose();
            }
        }
        this.disposed = true;
    }

    @Override
    public void enableUpdatePropagation() {
        if (this.children != null) {
            for (int i = 0; i < this.childrenIndex; ++i) {
                IWidgetItem child = this.children[i];
                child.enableUpdatePropagation();
            }
        }
        --this.redraw;
        if (this.redraw < 0) {
            this.redraw = 0;
        }
    }

    public final synchronized Object getAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(key);
    }

    @Override
    public IWidgetItemFactory getFactory() {
        return this.factory;
    }

    @Override
    public Object getImpl() {
        return this.impl;
    }

    @Override
    public IWidgetItem getParent() {
        return this.parent;
    }

    protected IWidgetItem getRoot() {
        IWidgetItem result = this;
        while (result.getParent() != null) {
            result = result.getParent();
        }
        return result;
    }

    public Object getValue(String name) throws FieldException {
        Object property = this.getWidgetDefinition().getValue(name);
        if (property instanceof IFieldHandler) {
            return ((IFieldHandler)property).getValue((Object)this);
        }
        if (property instanceof IMethodHandler) {
            try {
                return ((IMethodHandler)property).invoke((Object)this, (IArgs)Args.create());
            }
            catch (MethodException e) {
                throw new FieldAccessException(name, (Throwable)e);
            }
        }
        return property;
    }

    @Override
    public final IWidgetDefinition getWidgetDefinition() {
        return this.definition;
    }

    @Override
    public IWidgetItem getWidgetItem(String path) {
        int pos = path.indexOf(47);
        if (pos > 0) {
            IWidgetItem childItem = this.basicGetWidgetItem(path.substring(0, pos));
            if (childItem != null) {
                return childItem.getWidgetItem(path.substring(pos + 1));
            }
            return null;
        }
        if (pos == 0) {
            return this.getRoot().getWidgetItem(path.substring(1));
        }
        return this.basicGetWidgetItem(path);
    }

    @Override
    public IWidgetItem[] getWidgetItems() {
        if (this.childrenIndex == 0) {
            return EMPTY;
        }
        IWidgetItem[] result = new IWidgetItem[this.childrenIndex];
        System.arraycopy(this.children, 0, result, 0, this.childrenIndex);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String name, IArgs args) throws MethodException {
        EventDispatcher tempDispatcher;
        WidgetItem widgetItem = this;
        synchronized (widgetItem) {
            tempDispatcher = this.dispatcher;
        }
        if (tempDispatcher != null) {
            InvokeIntercept event = new InvokeIntercept((Object)this, name, args);
            tempDispatcher.triggerEvent((Event)event);
            if (event.isVetoed()) {
                return event.getResult();
            }
        }
        Object result = null;
        IMethodHandler callback = this.getWidgetDefinition().getCallback(name);
        if (callback != null) {
            try {
                result = callback.invoke((Object)this, args);
            }
            catch (MethodException e) {
                if (ExceptionTools.isCancellation((Throwable)e)) {
                    return null;
                }
                throw e;
            }
        }
        if (tempDispatcher != null) {
            InvokeAccept event = new InvokeAccept((Object)this, name, args, result, null);
            tempDispatcher.triggerEvent((Event)event);
        }
        return result;
    }

    public boolean isEnabledUpdatePropagation() {
        return this.redraw <= 0;
    }

    public boolean isInvokeEnabled(String name, IArgs args) throws MethodException {
        IMethodHandler callback = this.getWidgetDefinition().getCallback(name);
        if (callback instanceof IMethodHandlerAccessibility) {
            return ((IMethodHandlerAccessibility)callback).isInvokeEnabled((Object)this, args);
        }
        return true;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public final synchronized Object removeAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.removeAttribute(key);
    }

    public synchronized void removeNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.removeNotificationListener(type, listener);
    }

    @Override
    public void removeWidgetItem(IWidgetItem item) {
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.childrenIndex; ++i) {
            if (this.children[i] != item) continue;
            if (i + 1 < this.childrenIndex) {
                System.arraycopy(this.children, i + 1, this.children, i, this.childrenIndex - i - 1);
            }
            this.children[--this.childrenIndex] = null;
            return;
        }
    }

    public final synchronized Object setAttribute(Object key, Object value) {
        if (this.attributes == null) {
            this.attributes = new AttributeMap();
        }
        return this.attributes.setAttribute(key, value);
    }

    public void setImpl(Object impl) {
        this.impl = impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setValue(String name, Object value) throws FieldException {
        if (this.updateNotify) {
            return null;
        }
        try {
            this.updateNotify = true;
            Object property = this.getWidgetDefinition().getValue(name);
            if (property instanceof IFieldHandler) {
                Object object = ((IFieldHandler)property).setValue((Object)this, value);
                return object;
            }
            Object object = this.getWidgetDefinition().setValue(name, value);
            return object;
        }
        finally {
            this.updateNotify = false;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            this.triggerChange("visible", !visible, visible);
        }
    }

    public String toString() {
        return this.getWidgetDefinition() == null ? "undefined widget" : this.getWidgetDefinition().getPath();
    }

    @Override
    public void touch() {
        this.triggerChange(null, null, null);
    }

    @Override
    public void touchAll() {
        if (this.getWidgetDefinition() != null && this.getWidgetDefinition().isItem()) {
            this.touch();
        } else {
            IWidgetItem[] tempChildren = this.getWidgetItems();
            if (tempChildren != null) {
                for (int i = 0; i < this.childrenIndex; ++i) {
                    IWidgetItem child = tempChildren[i];
                    child.touchAll();
                }
            }
        }
    }

    protected void triggerChange(Object attribute, Object oldValue, Object newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, attribute, oldValue, newValue);
        this.triggerEvent(event);
    }

    protected void triggerEvent(AttributeChangedEvent event) {
        if (this.getFactory() == null || this.updateNotify) {
            return;
        }
        if (!this.isEnabledUpdatePropagation()) {
            return;
        }
        try {
            this.updateNotify = true;
            this.factory.fromWidgetItemTriggerChange(this, event);
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            this.updateNotify = false;
        }
    }
}

