/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.report.base;

import de.intarsys.document.model.IDocumentType;
import de.intarsys.report.base.IDocumentReportModel;
import de.intarsys.report.base.IDocumentReportModelFactory;
import de.intarsys.report.base.IReportRenderer;
import de.intarsys.report.base.IReportRendererFactory;
import de.intarsys.report.common.PACKAGE;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;
import java.util.ArrayList;

public class ReportEnvironment
implements IPreferencesSupport,
IPreferencesSyncher {
    private static ReportEnvironment ACTIVE = new ReportEnvironment();
    private static IMessageBundle Msg = PACKAGE.Messages;
    private IFactory[] reportModelFactories;
    private IFactory[] reportRendererFactories;
    private IPreferences preferences;

    public static ReportEnvironment get() {
        return ACTIVE;
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        IPreferences defaultPreferences = result.restrict("DEFAULT");
        this.preferencesInit(defaultPreferences);
        return result;
    }

    public IFactory[] getDocumentReportModelFactories(IDocumentType docType) {
        if (this.reportModelFactories == null) {
            this.reportModelFactories = Outlet.get().lookupFactories(IDocumentReportModel.class);
        }
        ArrayList<IDocumentReportModelFactory> myReportCreatorFactories = new ArrayList<IDocumentReportModelFactory>();
        for (int i = 0; i < this.reportModelFactories.length; ++i) {
            IDocumentReportModelFactory reportModelFactory = (IDocumentReportModelFactory)this.reportModelFactories[i];
            if (!this.supportsDocType(reportModelFactory, docType)) continue;
            myReportCreatorFactories.add(reportModelFactory);
        }
        return myReportCreatorFactories.toArray(new IFactory[myReportCreatorFactories.size()]);
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "com.cabaret.prefs.report";
    }

    public IFactory[] getReportRendererFactories(Class<?> modelType) {
        if (this.reportRendererFactories == null) {
            this.reportRendererFactories = Outlet.get().lookupFactories(IReportRenderer.class);
        }
        ArrayList<IReportRendererFactory> myReportRendererFactories = new ArrayList<IReportRendererFactory>();
        for (int i = 0; i < this.reportRendererFactories.length; ++i) {
            IReportRendererFactory reportRendererFactory = (IReportRendererFactory)this.reportRendererFactories[i];
            if (!this.supportsModelType(reportRendererFactory, modelType)) continue;
            myReportRendererFactories.add(reportRendererFactory);
        }
        return myReportRendererFactories.toArray(new IFactory[myReportRendererFactories.size()]);
    }

    protected void preferencesInit(IPreferences preferences) {
    }

    public void preferencesRestore() {
        IPreferences preferences = this.getPreferences();
    }

    public void preferencesStore() {
        IPreferences preferences = this.getPreferences();
    }

    protected boolean supportsDocType(IDocumentReportModelFactory<?> reportCreatorFactory, IDocumentType docType) {
        IDocumentType[] supportedDocTypes = reportCreatorFactory.getSupportedDocumentTypes();
        if (supportedDocTypes == null) {
            return true;
        }
        for (IDocumentType supportedDocType : supportedDocTypes) {
            if (!supportedDocType.getId().equals(docType.getId())) continue;
            return true;
        }
        return false;
    }

    protected boolean supportsModelType(IReportRendererFactory<?, ?> reportRendererFactory, Class<?> modelType) {
        Class<?> rendererModelType = reportRendererFactory.getModelClass();
        if (rendererModelType == null) {
            return false;
        }
        return rendererModelType.isAssignableFrom(modelType);
    }
}

