/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.report.common;

import de.intarsys.processor.common.CommonProcessorFactory;
import de.intarsys.report.base.IReportRenderer;
import de.intarsys.report.base.IReportRendererFactory;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.reflect.ObjectCreationException;

public abstract class CommonReportRendererFactory<P extends IReportRenderer, M>
extends CommonProcessorFactory<P>
implements IReportRendererFactory<P, M> {
    protected P basicCreateInstance(IArgs args) throws ObjectCreationException {
        Object model = args.get("model");
        return this.basicCreateReportRenderer(model, args);
    }

    protected abstract P basicCreateReportRenderer(M var1, IArgs var2) throws ObjectCreationException;

    protected String createReportName(M model, boolean replaceExtension) {
        Object localName = null;
        ILocator baseLocator = this.getReportBaseLocator(model);
        String suffix = this.getReportSuffix(model);
        localName = baseLocator == null ? suffix : (replaceExtension ? FileTools.getBaseName((String)baseLocator.getName()) + "." + suffix : baseLocator.getName() + "." + suffix);
        return localName;
    }

    protected abstract ILocator getReportBaseLocator(M var1);

    protected String getReportName(M model, IArgs args) {
        String reportName = ArgTools.getString((IArgs)args, (String)"reportName", null);
        if (reportName == null) {
            boolean replaceExtension = ArgTools.getBoolean((IArgs)args, (String)"replaceExtension", (boolean)false);
            reportName = this.createReportName(model, replaceExtension);
        }
        return reportName;
    }

    protected abstract String getReportSuffix(M var1);

    public Class<P> getResultType() {
        return IReportRenderer.class;
    }
}

