/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.boot;

import de.intarsys.spring.properties.PropertySourceTools;
import de.intarsys.tools.application.ApplicationComponent;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.reflect.ClassLoaderTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.support.StandardServletEnvironment;

public class XSpringApplicationBuilder
extends SpringApplicationBuilder {
    private StandardServletEnvironment environment;
    private ResourceLoader resourceLoader;
    private ClassLoader classloader;

    public XSpringApplicationBuilder(Class<?> ... sources) {
        super((Class[])sources);
    }

    public XSpringApplicationBuilder(ResourceLoader resourceLoader, Class<?> ... sources) {
        super(resourceLoader, (Class[])sources);
    }

    protected ClassLoader createClassloader() {
        String configShared;
        ArrayList urls = new ArrayList();
        ApplicationComponent app = ApplicationComponent.get();
        String configUser = this.getEnvironment().getProperty(app.prefixProperty("config.user"));
        if (!StringTools.isEmpty((String)configUser)) {
            File libDir = new File(configUser, "lib");
            ClassLoaderTools.collectURLsScan(urls, (File)libDir, Collections.emptyList());
            File classesDir = new File(configUser, "classes/");
            if (classesDir.exists()) {
                ClassLoaderTools.collectURLsFile(urls, (File)classesDir);
            }
        }
        if (!StringTools.isEmpty((String)(configShared = this.getEnvironment().getProperty(app.prefixProperty("config.shared")))) && !LangTools.equals((Object)configShared, (Object)configUser)) {
            File libDir = new File(configShared, "lib");
            ClassLoaderTools.collectURLsScan(urls, (File)libDir, Collections.emptyList());
            File classesDir = new File(configShared, "classes/");
            if (classesDir.exists()) {
                ClassLoaderTools.collectURLsFile(urls, (File)classesDir);
            }
        }
        if (urls.isEmpty()) {
            return ClassUtils.getDefaultClassLoader();
        }
        return ClassLoaderTools.createClassLoader((ClassLoader)ClassUtils.getDefaultClassLoader(), urls);
    }

    protected StandardServletEnvironment createEnvironment() {
        StandardServletEnvironment env = new StandardServletEnvironment();
        PropertySourceTools.addPropertySourceBuiltin((ConfigurableEnvironment)env);
        PropertySourceTools.addPropertySourceApplicationComponent((ConfigurableEnvironment)env);
        PropertySourceTools.addPropertySourceLocations((ConfigurableEnvironment)env);
        return env;
    }

    protected ResourceLoader createResourceLoader() {
        DefaultResourceLoader loader = new DefaultResourceLoader(this.getClassloader());
        return loader;
    }

    protected SpringApplication createSpringApplication(ResourceLoader resourceLoader, Class<?> ... sources) {
        SpringApplication app = new SpringApplication(this.getResourceLoader(), (Class[])sources);
        app.setEnvironment((ConfigurableEnvironment)this.getEnvironment());
        return app;
    }

    public ClassLoader getClassloader() {
        if (this.classloader == null) {
            this.classloader = this.createClassloader();
        }
        return this.classloader;
    }

    public StandardServletEnvironment getEnvironment() {
        if (this.environment == null) {
            this.environment = this.createEnvironment();
        }
        return this.environment;
    }

    public ResourceLoader getResourceLoader() {
        if (this.resourceLoader == null) {
            this.resourceLoader = this.createResourceLoader();
        }
        return this.resourceLoader;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    protected void setEnvironment(StandardServletEnvironment environment) {
        this.environment = environment;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

