/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.initializer;

import de.intarsys.tools.application.ApplicationComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public abstract class CommonApplicationContextInitializer<C extends ConfigurableApplicationContext>
implements ApplicationContextInitializer<C> {
    private static final Logger Log = LoggerFactory.getLogger(CommonApplicationContextInitializer.class);
    private ApplicationComponent applicationComponent;

    protected ApplicationComponent getApplicationComponent() {
        return this.applicationComponent;
    }

    protected String getProperty(ConfigurableApplicationContext applicationContext, String key) {
        return this.getProperty(applicationContext.getEnvironment(), key);
    }

    protected String getProperty(ConfigurableApplicationContext applicationContext, String key, String defaultValue) {
        return this.getProperty(applicationContext.getEnvironment(), key, defaultValue);
    }

    protected String getProperty(ConfigurableEnvironment environment, String name) {
        return environment.getProperty(name);
    }

    protected String getProperty(ConfigurableEnvironment environment, String name, String defaultValue) {
        return environment.getProperty(name, defaultValue);
    }

    protected String getPropertyPrefixed(ConfigurableApplicationContext applicationContext, String key) {
        return this.getProperty(applicationContext.getEnvironment(), this.prefixProperty(key));
    }

    protected String getPropertyPrefixed(ConfigurableApplicationContext applicationContext, String key, String defaultValue) {
        return this.getProperty(applicationContext.getEnvironment(), this.prefixProperty(key), defaultValue);
    }

    protected String getPropertyPrefixed(ConfigurableEnvironment environment, String name) {
        return this.getProperty(environment, this.prefixProperty(name));
    }

    protected String getPropertyPrefixed(ConfigurableEnvironment environment, String name, String defaultValue) {
        return this.getProperty(environment, this.prefixProperty(name), defaultValue);
    }

    public void initialize(ConfigurableApplicationContext ctxt) {
        Log.debug("{} initialize spring context {}", (Object)this, (Object)ctxt);
        this.setApplicationComponent(ApplicationComponent.get());
    }

    public String prefixProperty(String name) {
        return this.applicationComponent.prefixProperty(name);
    }

    protected void setApplicationComponent(ApplicationComponent application) {
        this.applicationComponent = application;
    }
}

