/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.initializer;

import de.intarsys.spring.initializer.CommonApplicationContextInitializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@Order
public class PrintBanner
extends CommonApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger Log = LoggerFactory.getLogger(PrintBanner.class);

    @Override
    public void initialize(ConfigurableApplicationContext context) {
        super.initialize(context);
        Stream<String> sources = Stream.of(this.getApplicationComponent().getApplicationFamily() + "." + this.getApplicationComponent().getName() + ".banner.txt", this.getApplicationComponent().getApplicationFamily() + ".banner.txt", "banner.txt");
        sources.map(ClassPathResource::new).filter(Resource::exists).findFirst().ifPresent(this::printBanner);
    }

    private void printBanner(Resource resource) {
        try (InputStream input = resource.getInputStream();
             InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(reader);){
            bufferedReader.lines().forEach(arg_0 -> ((Logger)Log).info(arg_0));
        }
        catch (IOException exception) {
            Log.warn("Failed to read banner from {}", (Object)resource, (Object)exception);
        }
    }

    public String toString() {
        return "banner printer";
    }
}

