/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.initializer;

import de.intarsys.spring.initializer.CommonApplicationContextInitializer;
import de.intarsys.tools.component.ComponentInfo;
import de.intarsys.tools.string.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;

@Order
public class PrintVersion
extends CommonApplicationContextInitializer {
    private static final Logger Log = LoggerFactory.getLogger(PrintVersion.class);

    protected String createMessage(ComponentInfo info, int level) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < level - 1; ++i) {
            sb.append("   ");
        }
        if (i < level) {
            sb.append("+- ");
        }
        sb.append(info.toStringShort());
        return sb.toString();
    }

    @Override
    public void initialize(ConfigurableApplicationContext ctxt) {
        super.initialize(ctxt);
        this.getApplicationComponent().createChildren();
        this.logComponentInfo((ComponentInfo)this.getApplicationComponent());
    }

    protected void logComponentInfo(ComponentInfo root) {
        Log.info("");
        Log.info("version info:");
        this.logComponentInfo(root, 0);
    }

    protected void logComponentInfo(ComponentInfo info, int level) {
        if (level == 0 || !StringTools.isEmpty((String)info.getVersion())) {
            Log.info(this.createMessage(info, level));
        }
        for (ComponentInfo child : info.getChildren()) {
            this.logComponentInfo(child, level + 1);
        }
    }

    public String toString() {
        return "version printer";
    }
}

