/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.license;

import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseProduct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class LicenseCheckListener
implements ApplicationListener<ContextRefreshedEvent> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (LicenseEnvironment.get().isAuthorized()) {
            return;
        }
        LicenseProduct licenseProduct = LicenseEnvironment.get().getLicenseProduct();
        if (licenseProduct == null) {
            throw new LicenseException("no main license product registered");
        }
        this.logger.error("{} not authorized", (Object)licenseProduct);
        throw new LicenseException("missing or invalid license");
    }
}

