/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.log;

import de.intarsys.spring.initializer.CommonApplicationContextInitializer;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.logging.logback.LogbackTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@Order(value=-98)
public class SpringLogInitializer
extends CommonApplicationContextInitializer {
    public static final DateTimeFormatter FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('-').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral('-').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral('-').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendOffsetId().toFormatter();
    private static final Logger Log = LoggerFactory.getLogger(SpringLogInitializer.class);

    protected Map<String, String> collectLogProperties(ConfigurableApplicationContext ctxt) {
        HashMap<String, String> properties = new HashMap<String, String>();
        String id = FORMAT.format(LocalDateTime.now());
        properties.put("config.shared", this.getPropertyPrefixed(ctxt, "config.shared"));
        properties.put("config.user", this.getPropertyPrefixed(ctxt, "config.user"));
        properties.put("data.shared", this.getPropertyPrefixed(ctxt, "data.shared"));
        properties.put("data.user", this.getPropertyPrefixed(ctxt, "data.user"));
        properties.put("log.dir", this.getPropertyPrefixed(ctxt, "log.dir"));
        properties.put("log.name", this.getPropertyPrefixed(ctxt, "log.name"));
        properties.put("log.id", id);
        properties.put("log.level", this.getPropertyPrefixed(ctxt, "log.level", "INFO"));
        properties.put(this.prefixProperty("config.shared"), this.getPropertyPrefixed(ctxt, "config.shared"));
        properties.put(this.prefixProperty("config.user"), this.getPropertyPrefixed(ctxt, "config.user"));
        properties.put(this.prefixProperty("data.shared"), this.getPropertyPrefixed(ctxt, "data.shared"));
        properties.put(this.prefixProperty("data.user"), this.getPropertyPrefixed(ctxt, "data.user"));
        properties.put(this.prefixProperty("log.dir"), this.getPropertyPrefixed(ctxt, "log.dir"));
        properties.put(this.prefixProperty("log.name"), this.getPropertyPrefixed(ctxt, "log.name"));
        properties.put(this.prefixProperty("log.id"), id);
        properties.put(this.prefixProperty("log.level"), this.getPropertyPrefixed(ctxt, "log.level", "INFO"));
        return properties;
    }

    protected Resource detectLogConfiguration(ConfigurableApplicationContext ctxt) {
        URL configurationUrl;
        if (!"true".equals(this.getPropertyPrefixed(ctxt, "log.override", "")) && (configurationUrl = LogbackTools.getConfigurationURL()) != null) {
            Log.info("{} init spring, log already configured from {}", (Object)this, (Object)configurationUrl);
            return null;
        }
        Resource res = null;
        String config = this.getPropertyPrefixed(ctxt, "log.config");
        if (!StringTools.isEmpty((String)config)) {
            res = this.detectLogConfiguration(ctxt, "logback-" + config + ".xml");
        }
        if (res == null || !res.exists()) {
            Log.info("{} init spring, no log configuration {}", (Object)this, (Object)res);
            res = this.detectLogConfiguration(ctxt, "logback.xml");
        }
        return res;
    }

    protected Resource detectLogConfiguration(ConfigurableApplicationContext ctxt, String fileName) {
        FileSystemResource res = new FileSystemResource(PathTools.join((String[])new String[]{this.getPropertyPrefixed(ctxt, "config.user"), fileName}));
        if (!res.exists()) {
            Log.info("{} init spring, no log configuration {}", (Object)this, (Object)res);
            res = new FileSystemResource(PathTools.join((String[])new String[]{this.getPropertyPrefixed(ctxt, "config.shared"), fileName}));
        }
        if (!res.exists()) {
            Log.info("{} init spring, no log configuration {}", (Object)this, (Object)res);
            res = new ClassPathResource(PathTools.join((String[])new String[]{"default", fileName}));
        }
        return res;
    }

    @Override
    public void initialize(ConfigurableApplicationContext ctxt) {
        super.initialize(ctxt);
        Resource res = this.detectLogConfiguration(ctxt);
        if (res == null || !res.exists()) {
            Log.info("{} init spring, no log configuration {}", (Object)this, (Object)res);
            return;
        }
        Log.info("{} init spring, use log configuration {}", (Object)this, (Object)res);
        Map<String, String> properties = this.collectLogProperties(ctxt);
        try {
            LogbackTools.configure((InputStream)res.getInputStream(), properties);
        }
        catch (IOException e) {
            Log.info("{} init spring, error reading log configuration {}", (Object)this, (Object)res);
        }
    }

    public String toString() {
        return "log initializer";
    }
}

