/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.nls;

import de.intarsys.spring.initializer.CommonApplicationContextInitializer;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.message.DirectoryMessageClassLoaderProvider;
import de.intarsys.tools.message.IMessageClassLoaderProvider;
import de.intarsys.tools.servicelocator.ServiceLocator;
import de.intarsys.tools.string.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;

@Order(value=-98)
public class DirectoryMessageClassLoaderInitializer
extends CommonApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger Log = LoggerFactory.getLogger(DirectoryMessageClassLoaderInitializer.class);

    @Override
    public void initialize(ConfigurableApplicationContext ctxt) {
        super.initialize(ctxt);
        String i18nDir = this.getPropertyPrefixed(ctxt, "i18n.dir");
        if (StringTools.isEmpty((String)i18nDir)) {
            i18nDir = PathTools.join((String[])new String[]{this.getPropertyPrefixed(ctxt, "config.shared"), "i18n"});
        }
        Log.info("message directory set to '{}'", (Object)i18nDir);
        DirectoryMessageClassLoaderProvider provider = new DirectoryMessageClassLoaderProvider();
        provider.setPath(i18nDir);
        ServiceLocator.get().put(IMessageClassLoaderProvider.class, (Object)provider);
    }
}

