/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.nls;

import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.MessageTools;
import org.springframework.core.env.PropertySource;

public class NLSMessagePropertySource
extends PropertySource {
    public static final char SEPARATOR = '#';
    public static final String PREFIX = "nlsmsg";

    public NLSMessagePropertySource() {
        super(PREFIX);
    }

    public Object getProperty(String name) {
        if (!name.startsWith(PREFIX)) {
            return null;
        }
        int index = name.indexOf(35);
        if (index < 0 || index == name.length()) {
            return "invalid nlsmsg '" + name + "'";
        }
        String bundleName = name.substring(PREFIX.length() + 1, index);
        String msgCode = name.substring(index + 1);
        IMessageBundle messageBundle = MessageTools.getMessageBundle((String)bundleName, (ClassLoader)null);
        return messageBundle.getMessage(msgCode, new Object[0]);
    }
}

