/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.preferences;

import de.intarsys.spring.preferences.SpringPreferences;
import de.intarsys.spring.preferences.SpringUnknownPreferences;
import de.intarsys.spring.tools.IPathCanonicalizer;
import de.intarsys.spring.tools.PathCanonicalizer;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;

public class SpringMappedPreferences
extends AbstractPreferences {
    @Autowired
    private ConfigurableEnvironment environment;
    private Map<String, String> nameMapping = new HashMap<String, String>();
    private IPathCanonicalizer canonicalizer;

    public SpringMappedPreferences() {
        super(null, "");
        this.canonicalizer = new PathCanonicalizer(false, false, false);
    }

    public SpringMappedPreferences(IPathCanonicalizer canonicalizer) {
        super(null, "");
        this.canonicalizer = canonicalizer;
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        return this.nameMapping.keySet().toArray(new String[this.nameMapping.size()]);
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        String mapped = this.nameMapping.get(name);
        if (mapped == null) {
            return new SpringUnknownPreferences(this.environment, null, "");
        }
        return new SpringPreferences(this.environment, this.canonicalizer, mapped, "");
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    public IPathCanonicalizer getCanonicalizer() {
        return this.canonicalizer;
    }

    protected ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }

    public Map<String, String> getNameMapping() {
        return this.nameMapping;
    }

    @Override
    protected String getSpi(String key) {
        return null;
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        return new String[0];
    }

    @Override
    protected void putSpi(String key, String value) {
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
    }

    @Override
    protected void removeSpi(String key) {
    }

    public void setCanonicalizer(IPathCanonicalizer canonicalizer) {
        this.canonicalizer = canonicalizer;
    }

    public void setEnvironment(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public void setNameMapping(Map<String, String> rootNameMapping) {
        this.nameMapping = rootNameMapping;
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
    }
}

