/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.preferences;

import de.intarsys.spring.tools.IPathCanonicalizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

public class SpringPreferences
extends AbstractPreferences {
    private ConfigurableEnvironment environment;
    private Map<String, String> properties;
    private Set<String> children;
    private Set<String> keys;
    private Set<String> subset;
    private final String path;
    private final IPathCanonicalizer canonicalizer;

    protected SpringPreferences(ConfigurableEnvironment environment, IPathCanonicalizer canonicalizer, String path, String name) {
        super(null, name);
        this.environment = environment;
        this.path = path;
        this.canonicalizer = canonicalizer;
        this.properties = new HashMap<String, String>();
    }

    protected SpringPreferences(ConfigurableEnvironment environment, SpringPreferences parent, String path, String name) {
        super(parent, name);
        this.environment = environment;
        this.path = path;
        this.properties = parent.properties;
        this.canonicalizer = parent.canonicalizer;
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        this.initNode();
        return this.children.toArray(new String[this.children.size()]);
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        this.initNode();
        SpringPreferences result = new SpringPreferences(this.environment, this, this.prefixed(name), name);
        if (!this.children.contains(name)) {
            result.newNode = true;
            this.children.add(name);
        }
        return result;
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    protected ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    protected String getSpi(String key) {
        this.initNode();
        String tmpKey = this.canonicalizer.canonicalize(key);
        return this.properties.get(this.prefixed(tmpKey));
    }

    protected void initNode() {
        if (this.children != null) {
            return;
        }
        String tmpPrefix = this.prefixed("");
        this.keys = new HashSet<String>();
        this.children = new HashSet<String>();
        this.subset = new HashSet<String>();
        if (this.parent() == null) {
            for (PropertySource propertySource : this.environment.getPropertySources()) {
                if (!(propertySource instanceof EnumerablePropertySource)) continue;
                for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                    String tmpKey = this.canonicalizer.canonicalize(key);
                    if (!tmpKey.startsWith(tmpPrefix)) continue;
                    String value = this.environment.getProperty(key);
                    this.properties.put(tmpKey, value);
                    this.subset.add(tmpKey);
                }
            }
            this.initSubset(this.subset, tmpPrefix);
        } else {
            this.initSubset(((SpringPreferences)this.parent()).subset, tmpPrefix);
        }
    }

    protected void initSubset(Set<String> tmp, String tmpPrefix) {
        for (String tmpKey : tmp) {
            if (!tmpKey.startsWith(tmpPrefix)) continue;
            String tmpRest = tmpKey.substring(tmpPrefix.length());
            int pos = tmpRest.indexOf(46);
            if (pos >= 0) {
                this.children.add(tmpRest.substring(0, pos));
            } else {
                this.keys.add(tmpRest);
            }
            this.subset.add(tmpKey);
        }
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        this.initNode();
        return this.keys.toArray(new String[this.keys.size()]);
    }

    @Override
    public Preferences node(String path) {
        return super.node(this.canonicalizer.canonicalize(path));
    }

    @Override
    public boolean nodeExists(String path) throws BackingStoreException {
        return super.nodeExists(this.canonicalizer.canonicalize(path));
    }

    protected String prefixed(String name) {
        return this.path.isEmpty() ? name : this.path + "." + name;
    }

    @Override
    protected void putSpi(String key, String value) {
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
    }

    @Override
    protected void removeSpi(String key) {
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
    }
}

