/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.properties;

import de.intarsys.tools.string.StringTools;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

@Order
public class PrintProperties
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger Log = LoggerFactory.getLogger(PrintProperties.class);
    private static final String HIDE_PROPERTY = "de.intarsys.spring.tools.PrintProperties.hide";
    private static final Pattern SYSTEM_PROPERTY_PATTERN = Pattern.compile("-D(?<name>.*)=(.*)");
    private Pattern hidePattern;

    public void initialize(ConfigurableApplicationContext context) {
        String regex;
        if (this.hidePattern == null && !StringTools.isEmpty((String)(regex = context.getEnvironment().getProperty(HIDE_PROPERTY)))) {
            this.hidePattern = Pattern.compile(regex);
        }
        Log.info("");
        Log.info("spring properties");
        Log.info("+- vm arguments");
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        for (String argument : arguments) {
            Log.info("   +- argument '{}'", (Object)this.maskArgument(argument));
        }
        Log.info("+- property sources");
        for (PropertySource propertySource : context.getEnvironment().getPropertySources()) {
            Log.info("   +- property source {}", (Object)propertySource.getName());
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
            Object[] propertyNames = enumerablePropertySource.getPropertyNames();
            Arrays.sort(propertyNames);
            for (Object name : propertyNames) {
                Object value = this.isHidden((String)name) ? Character.valueOf('?') : enumerablePropertySource.getProperty((String)name);
                Log.info("   |  +- {}={}", name, value);
            }
        }
    }

    private boolean isHidden(String name) {
        return this.hidePattern != null && this.hidePattern.matcher(name).matches();
    }

    private String maskArgument(String argument) {
        String name;
        if (this.hidePattern == null) {
            return argument;
        }
        Matcher matcher = SYSTEM_PROPERTY_PATTERN.matcher(argument);
        if (matcher.matches() && this.isHidden(name = matcher.group("name"))) {
            return "-D" + name + "=?";
        }
        return argument;
    }

    public void setHide(Pattern hidePattern) {
        this.hidePattern = hidePattern;
    }

    public String toString() {
        return "property printer";
    }
}

