/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.properties;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class PropertySourceSubsetResolver
implements IStringEvaluator {
    @Autowired
    private Environment environment;
    private String prefix = "config";

    public PropertySourceSubsetResolver() {
    }

    public PropertySourceSubsetResolver(String prefix) {
        this.prefix = prefix;
    }

    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        String key = this.getPrefix() + "." + expression;
        try {
            String resolved = this.getEnvironment().getRequiredProperty(key);
            return resolved.replace("?{", "${");
        }
        catch (Exception e) {
            throw this.failed(expression);
        }
    }

    protected EvaluationException failed(String expression) throws EvaluationException {
        throw new EvaluationException("can't evaluate '" + expression + "'");
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setPrefix(String namespace) {
        this.prefix = namespace;
    }
}

