/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.properties;

import de.intarsys.spring.application.ApplicationComponentPropertySource;
import de.intarsys.spring.application.SpringApplicationComponentTools;
import de.intarsys.spring.secret.SecretPropertySource;
import de.intarsys.tools.application.ApplicationComponent;
import de.intarsys.tools.system.SystemTools;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.io.support.ResourcePropertySource;

public abstract class PropertySourceTools {
    private static final String DEF_LOG_DIR = "${user.home}/${app.family}/log";
    private static final String DEF_DATA_SHARED = "${user.home}/${app.family}/data";
    private static final String DEF_DATA_USER = "${user.home}/${app.family}/data";
    private static final String DEF_CONFIG_SHARED = "${user.home}/${app.family}/config";
    private static final String DEF_CONFIG_USER = "${user.home}/${app.family}/config";
    public static final String PS_LOCATIONS = "locations";
    public static final String PS_BUILTIN = "builtin";
    public static final String PS_BUILTIN_PLATFORM = "builtin-platform";
    public static final String PS_SECRET = "secret";
    public static final String PS_APP = "app";
    private static final Logger Log = LoggerFactory.getLogger(PropertySourceTools.class);

    public static PropertySource addPropertySourceApplicationComponent(ConfigurableEnvironment env) {
        Object psApp = env.getPropertySources().get(PS_APP);
        if (psApp != null) {
            return psApp;
        }
        SpringApplicationComponentTools.configure(ApplicationComponent.get(), env);
        ApplicationComponent.get().read();
        psApp = new ApplicationComponentPropertySource(PS_APP);
        env.getPropertySources().addLast(psApp);
        return psApp;
    }

    public static PropertySource addPropertySourceBuiltin(ConfigurableEnvironment env) {
        PropertySource psBuiltin = env.getPropertySources().get(PS_BUILTIN);
        if (psBuiltin != null) {
            return psBuiltin;
        }
        Object tmpTarget = "classpath:builtin.properties";
        psBuiltin = PropertySourceTools.createPropertySourceResource(env, PS_BUILTIN, (String)tmpTarget);
        if (psBuiltin == null) {
            psBuiltin = new MapPropertySource(PS_BUILTIN, new HashMap());
        }
        env.getPropertySources().addLast(psBuiltin);
        tmpTarget = "classpath:builtin-" + SystemTools.getOSCode() + ".properties";
        PropertySource psBuiltinPlatform = PropertySourceTools.createPropertySourceResource(env, PS_BUILTIN_PLATFORM, (String)tmpTarget);
        if (psBuiltinPlatform == null) {
            psBuiltinPlatform = new MapPropertySource(PS_BUILTIN_PLATFORM, new HashMap());
        }
        env.getPropertySources().addBefore(PS_BUILTIN, psBuiltinPlatform);
        return psBuiltinPlatform;
    }

    public static PropertySource addPropertySourceLocations(ConfigurableEnvironment env) {
        PropertySource ps = env.getPropertySources().get(PS_LOCATIONS);
        if (ps != null) {
            return ps;
        }
        ps = PropertySourceTools.createPropertySourceLocations(env);
        env.getPropertySources().addBefore(PS_BUILTIN_PLATFORM, ps);
        return ps;
    }

    public static PropertySource addPropertySourceSecret(ConfigurableEnvironment env) {
        PropertySource result = env.getPropertySources().get(PS_SECRET);
        if (result != null) {
            return result;
        }
        result = PropertySourceTools.createPropertySourceSecret(env);
        env.getPropertySources().addLast(result);
        return result;
    }

    public static PropertySource createPropertySourceLocations(ConfigurableEnvironment env) {
        Log.info("property source create locations for " + SystemTools.getOSCode());
        ApplicationComponent app = ApplicationComponent.get();
        HashMap<String, Object> bootstrapMap = new HashMap<String, Object>();
        String propConfigUser = app.prefixProperty("config.user");
        String propConfigShared = app.prefixProperty("config.shared");
        String propDataUser = app.prefixProperty("data.user");
        String propDataShared = app.prefixProperty("data.shared");
        String propLogDir = app.prefixProperty("log.dir");
        String propLogName = app.prefixProperty("log.name");
        bootstrapMap.put(propConfigUser, env.getProperty("template.config.user", "${user.home}/${app.family}/config"));
        bootstrapMap.put(propConfigShared, env.getProperty("template.config.shared", "${user.home}/${app.family}/config"));
        bootstrapMap.put(propDataUser, env.getProperty("template.data.user", "${user.home}/${app.family}/data"));
        bootstrapMap.put(propDataShared, env.getProperty("template.data.shared", "${user.home}/${app.family}/data"));
        bootstrapMap.put(propLogDir, env.getProperty("template.log.dir", DEF_LOG_DIR));
        bootstrapMap.put(propLogName, app.getName());
        String propBaseDir = app.prefixProperty("base.dir");
        String propProfileDir = app.prefixProperty("profile.dir");
        String propDataDir = app.prefixProperty("data.dir");
        String propTempDir = app.prefixProperty("temp.dir");
        bootstrapMap.put(propBaseDir, env.getProperty("user.dir"));
        bootstrapMap.put(propProfileDir, "${" + propConfigShared + "}");
        bootstrapMap.put(propDataDir, "${" + propDataShared + "}");
        bootstrapMap.put(propTempDir, env.getProperty("java.io.tmpdir"));
        return new MapPropertySource(PS_LOCATIONS, bootstrapMap);
    }

    public static PropertySource createPropertySourceResource(ConfigurableEnvironment env, String name, String path) {
        try {
            String expanded = env.resolveRequiredPlaceholders(path);
            Log.debug("Create PropertySource {} at {}", (Object)name, (Object)expanded);
            ResourcePropertySource propertySource = new ResourcePropertySource(name, expanded);
            Log.info("PropertySource {} at {} loaded", (Object)name, (Object)path);
            return propertySource;
        }
        catch (IOException e) {
            Log.info("PropertySource {} at {} not available", (Object)name, (Object)path);
            return null;
        }
    }

    public static PropertySource createPropertySourceResources(ConfigurableEnvironment env, ResourceLoader loader, String name, String path) {
        try {
            Resource[] resources;
            CompositePropertySource propertySource = new CompositePropertySource(name);
            String expanded = env.resolveRequiredPlaceholders(path);
            Log.debug("Create composite PropertySource {} at {}", (Object)name, (Object)expanded);
            for (Resource resource : resources = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)loader).getResources(expanded)) {
                Log.debug("Create composite PropertySource {} found {}", (Object)name, (Object)resource.getDescription());
                ResourcePropertySource child = new ResourcePropertySource(resource);
                propertySource.addPropertySource((PropertySource)child);
            }
            return propertySource;
        }
        catch (IOException e) {
            Log.info("Create PropertySource {} at {} not available", (Object)name, (Object)path);
            return null;
        }
    }

    public static PropertySource createPropertySourceSecret(ConfigurableEnvironment env) {
        return new SecretPropertySource();
    }

    private static String getSubKey(String name, String keyPrefix) {
        if (name.startsWith(keyPrefix)) {
            return name.substring(keyPrefix.length());
        }
        return null;
    }

    public static Map<String, Object> getSubProperties(PropertySources propertySources, String keyPrefix) {
        LinkedHashMap<String, Object> subProperties = new LinkedHashMap<String, Object>();
        for (PropertySource source : propertySources) {
            if (!(source instanceof EnumerablePropertySource)) continue;
            for (String name : ((EnumerablePropertySource)source).getPropertyNames()) {
                String key = PropertySourceTools.getSubKey(name, keyPrefix);
                if (key == null) continue;
                subProperties.computeIfAbsent(key, ignore -> source.getProperty(name));
            }
        }
        return Collections.unmodifiableMap(subProperties);
    }

    private PropertySourceTools() {
    }
}

