/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.properties;

import de.intarsys.spring.initializer.CommonApplicationContextInitializer;
import de.intarsys.spring.properties.PropertySourceTools;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.lang.LangTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

@Order(value=-99)
public class SharedAndUserPropertySourceRegistrar
extends CommonApplicationContextInitializer<ConfigurableApplicationContext> {
    public static final int PRECEDENCE = -99;
    private static final Logger Log = LoggerFactory.getLogger(SharedAndUserPropertySourceRegistrar.class);

    protected PropertySource addPropertySourceResource(ConfigurableEnvironment env, PropertySource before, String name, String path) {
        PropertySource ps = PropertySourceTools.createPropertySourceResource(env, name, path);
        if (ps != null) {
            env.getPropertySources().addBefore(before.getName(), ps);
            return ps;
        }
        return before;
    }

    @Override
    public void initialize(ConfigurableApplicationContext ctxt) {
        String tmpName;
        String profileString;
        boolean addConfigUser;
        PropertySource psShared;
        super.initialize(ctxt);
        ConfigurableEnvironment env = ctxt.getEnvironment();
        PropertySource psLocations = PropertySourceTools.addPropertySourceLocations(env);
        String fileConfigName = this.getPropertyPrefixed(env, "config.name", this.getApplicationComponent().getName());
        Object tmpPath = "classpath:" + fileConfigName + ".properties";
        PropertySource psClasspath = this.addPropertySourceResource(env, psLocations, "classpath", (String)tmpPath);
        String pathConfigShared = "file:" + this.getPropertyPrefixed(ctxt, "config.shared");
        tmpPath = PathTools.join((String[])new String[]{pathConfigShared, fileConfigName + ".properties"});
        PropertySource psUser = psShared = this.addPropertySourceResource(env, psClasspath, "shared", (String)tmpPath);
        String pathConfigUser = "file:" + this.getPropertyPrefixed(ctxt, "config.user");
        boolean bl = addConfigUser = !LangTools.equals((Object)pathConfigShared, (Object)pathConfigUser);
        if (addConfigUser) {
            tmpPath = PathTools.join((String[])new String[]{pathConfigUser, fileConfigName + ".properties"});
            psUser = this.addPropertySourceResource(env, psShared, "user", (String)tmpPath);
        }
        if (StringUtils.hasText((String)(profileString = env.getProperty("spring.profiles.active")))) {
            String[] tempProfiles = StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)profileString));
            for (String profile : tempProfiles) {
                env.addActiveProfile(profile);
            }
        }
        PropertySource psCurrent = psShared;
        for (String profile : env.getActiveProfiles()) {
            tmpName = fileConfigName + "-" + profile + ".properties";
            tmpPath = PathTools.join((String[])new String[]{pathConfigShared, tmpName});
            psCurrent = this.addPropertySourceResource(env, psCurrent, "shared." + profile, (String)tmpPath);
        }
        if (addConfigUser) {
            psCurrent = psUser == psShared ? psCurrent : psUser;
            for (String profile : env.getActiveProfiles()) {
                tmpName = fileConfigName + "-" + profile + ".properties";
                tmpPath = PathTools.join((String[])new String[]{pathConfigUser, tmpName});
                psCurrent = this.addPropertySourceResource(env, psCurrent, "user." + profile, (String)tmpPath);
            }
        }
    }

    public String toString() {
        return "property initializer";
    }
}

