/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.properties;

import de.intarsys.spring.tools.IPathCanonicalizer;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.infoset.AbstractAttribute;
import de.intarsys.tools.infoset.AbstractElement;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.INode;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;

public class SpringPropertiesElementAdapter
extends AbstractElement {
    private final ConfigurableEnvironment environment;
    private final String path;
    private final SpringPropertiesElementAdapter parent;
    private final String name;
    private Set<String> attributes;
    private Set<String> elements;
    private Map<String, Object> properties;
    private Set<String> subset;
    private final IPathCanonicalizer canonicalizer;

    protected SpringPropertiesElementAdapter(ConfigurableEnvironment environment, IPathCanonicalizer canonicalizer, String path, String name) {
        super(false);
        this.environment = environment;
        this.parent = null;
        this.path = path;
        this.name = name;
        this.properties = new HashMap<String, Object>();
        this.canonicalizer = canonicalizer;
    }

    protected SpringPropertiesElementAdapter(ConfigurableEnvironment environment, SpringPropertiesElementAdapter parent, String path, String name) {
        super(false);
        this.environment = environment;
        this.parent = parent;
        this.path = path;
        this.name = name;
        this.properties = parent.properties;
        this.canonicalizer = parent.canonicalizer;
    }

    public IAttribute attribute(String name) {
        this.initNode();
        String tmpName = this.canonicalizer.canonicalize(name);
        if (this.attributes.contains(tmpName)) {
            return new SpringPropertiesAttributeAdapter(this, tmpName);
        }
        return null;
    }

    public Iterator<IAttribute> attributeIterator() {
        this.initNode();
        return new ConversionIterator<String, IAttribute>(this.attributes.iterator()){

            protected IAttribute createTargetObject(String name) {
                return new SpringPropertiesAttributeAdapter(SpringPropertiesElementAdapter.this, name);
            }
        };
    }

    public Iterator<String> attributeNames() {
        this.initNode();
        return this.attributes.iterator();
    }

    protected Object basicGetAttributeData(IAttribute attribute, String name) {
        this.initNode();
        String tmpName = this.canonicalizer.canonicalize(name);
        return this.properties.get(this.prefixed(tmpName));
    }

    protected Object basicGetAttributeRaw(IAttribute attribute, String name) {
        return this.basicGetAttributeData(attribute, name);
    }

    protected String basicGetAttributeValue(IAttribute attribute, String name) {
        this.initNode();
        String tmpName = this.canonicalizer.canonicalize(name);
        Object value = this.properties.get(this.prefixed(tmpName));
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return (String)this.environment.getConversionService().convert(value, String.class);
    }

    protected void basicSetAttributeData(IAttribute attribute, String name, Object data) {
        throw new UnsupportedOperationException();
    }

    protected void basicSetAttributeRaw(IAttribute attribute, String name, Object raw) {
        throw new UnsupportedOperationException();
    }

    protected void basicSetAttributeValue(IAttribute attribute, String name, String value) {
        throw new UnsupportedOperationException();
    }

    public IElement element(String name) {
        this.initNode();
        String tmpName = this.canonicalizer.canonicalize(name);
        if (this.elements.contains(tmpName)) {
            return new SpringPropertiesElementAdapter(this.environment, this, this.prefixed(tmpName), tmpName);
        }
        return null;
    }

    public Iterator<IElement> elementIterator() {
        this.initNode();
        return this.elements.stream().map(e -> new SpringPropertiesElementAdapter(this.environment, this, this.prefixed((String)e), (String)e)).iterator();
    }

    public Iterator<IElement> elementIterator(String name) {
        this.initNode();
        String tmpName = this.canonicalizer.canonicalize(name);
        if (this.elements.contains(tmpName)) {
            return Collections.singleton(new SpringPropertiesElementAdapter(this.environment, this, this.prefixed(tmpName), tmpName)).iterator();
        }
        return Collections.emptyListIterator();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean hasAttribute(String name) {
        this.initNode();
        String tmpName = this.canonicalizer.canonicalize(name);
        return this.attributes.contains(tmpName);
    }

    public boolean hasAttributes() {
        this.initNode();
        return !this.attributes.isEmpty();
    }

    public boolean hasElements() {
        this.initNode();
        return !this.elements.isEmpty();
    }

    public boolean hasElements(String name) {
        this.initNode();
        String tmpName = this.canonicalizer.canonicalize(name);
        return this.elements.contains(tmpName);
    }

    protected void initNode() {
        if (this.attributes != null) {
            return;
        }
        String tmpPrefix = this.prefixed("");
        this.attributes = new HashSet<String>();
        this.elements = new HashSet<String>();
        this.subset = new HashSet<String>();
        if (this.parent == null) {
            for (PropertySource propertySource : this.environment.getPropertySources()) {
                if (!(propertySource instanceof EnumerablePropertySource)) continue;
                for (String key : ((EnumerablePropertySource)propertySource).getPropertyNames()) {
                    String tmpKey = this.canonicalizer.canonicalize(key);
                    if (!tmpKey.startsWith(tmpPrefix)) continue;
                    Object value = this.environment.getProperty(key, Object.class);
                    this.properties.put(tmpKey, value);
                    this.subset.add(tmpKey);
                }
            }
            this.initSubset(this.subset, tmpPrefix);
        } else {
            this.initSubset(this.parent.subset, tmpPrefix);
        }
    }

    protected void initSubset(Set<String> tmp, String tmpPrefix) {
        for (String tmpKey : tmp) {
            if (!tmpKey.startsWith(tmpPrefix)) continue;
            String tmpRest = tmpKey.substring(tmpPrefix.length());
            int pos = tmpRest.indexOf(46);
            if (pos >= 0) {
                this.elements.add(tmpRest.substring(0, pos));
            } else {
                this.attributes.add(tmpRest);
            }
            this.subset.add(tmpKey);
        }
    }

    public Iterator<INode> nodeIterator() {
        this.initNode();
        Stream<IAttribute> streamAttrs = this.attributes.stream().map(name -> new SpringPropertiesAttributeAdapter(this, (String)name));
        Stream<IElement> streamElem = this.elements.stream().map(name -> new SpringPropertiesElementAdapter(this.environment, this, this.prefixed((String)name), (String)name));
        return Stream.concat(streamAttrs, streamElem).iterator();
    }

    protected String prefixed(String name) {
        return this.path.isEmpty() ? name : this.path + "." + name;
    }

    public class SpringPropertiesAttributeAdapter
    extends AbstractAttribute {
        public SpringPropertiesAttributeAdapter(SpringPropertiesElementAdapter element, String name) {
            super((AbstractElement)element, name);
        }
    }
}

