/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.properties;

import de.intarsys.spring.properties.PropertySourceTools;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySources;

@Order(value=-98)
public class SystemPropertiesInjector
implements ApplicationContextInitializer {
    private static final Logger Log = LoggerFactory.getLogger(SystemPropertiesInjector.class);

    public void initialize(ConfigurableApplicationContext ctxt) {
        MutablePropertySources ps = ctxt.getEnvironment().getPropertySources();
        Map<String, Object> alwaysProps = PropertySourceTools.getSubProperties((PropertySources)ps, "system.");
        for (Map.Entry<String, Object> prop : alwaysProps.entrySet()) {
            String key = prop.getKey();
            String value = String.valueOf(prop.getValue());
            String oldValue = System.getProperty(key, null);
            System.setProperty(key, value);
            if (oldValue == null) {
                Log.info("system property set '" + key + "' to '" + value + "'");
                continue;
            }
            Log.info("system property change '" + key + "' from '" + oldValue + "' to '" + value + "'");
        }
        Map<String, Object> optionalProps = PropertySourceTools.getSubProperties((PropertySources)ps, "system-optional.");
        for (Map.Entry<String, Object> prop : optionalProps.entrySet()) {
            String key = prop.getKey();
            String value = String.valueOf(prop.getValue());
            String oldValue = System.getProperty(key, null);
            if (oldValue == null) {
                System.setProperty(key, value);
                Log.info("system property set '" + key + "' to '" + value + "'");
                continue;
            }
            Log.info("system property keep '" + key + "' as '" + oldValue + "'");
        }
    }

    public String toString() {
        return "system property synchronizer";
    }
}

