/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.schema.widget;

import de.intarsys.tools.string.StringTools;
import de.intarsys.widget.model.ActionSpec;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ActionBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String ATTR_DO = "do";
    private static final String ATTR_ACTION = "action";
    private static final String EL_ACTION = "action";
    private static final String EL_CATCH = "catch";
    private static final String EL_FINALLY = "finally";

    public static BeanDefinitionBuilder createActionSpecBuilder(Element element) {
        return BeanDefinitionBuilder.rootBeanDefinition((Class)ActionBeanDefinitionParser.getBeanClass(element));
    }

    public static Class getBeanClass(Element element) {
        return ActionSpec.class;
    }

    public static AbstractBeanDefinition parseActionSpecBlock(Element element, ParserContext parserContext, BeanDefinition parent) {
        String id;
        BeanDefinitionBuilder builder = ActionBeanDefinitionParser.createActionSpecBuilder(null);
        builder.addPropertyValue("factory", (Object)"Block");
        ManagedMap args = new ManagedMap();
        builder.addPropertyValue("args", (Object)args);
        ManagedList actions = new ManagedList();
        args.put((Object)"try", (Object)actions);
        AbstractBeanDefinition singleActionDefinition = null;
        List elements = DomUtils.getChildElements((Element)element);
        boolean catchFound = false;
        boolean finallyFound = false;
        for (Element childElement : elements) {
            String localName = childElement.getLocalName();
            if ("entry".equals(localName)) continue;
            Object childObject = parserContext.getDelegate().parsePropertySubElement(childElement, parent);
            if (EL_CATCH.equals(localName)) {
                if (finallyFound) {
                    parserContext.getReaderContext().error("'catch' not allowed after 'finally'", (Object)element);
                    return null;
                }
                if (catchFound) {
                    parserContext.getReaderContext().error("only a single 'catch' element allowed", (Object)element);
                    return null;
                }
                catchFound = true;
                singleActionDefinition = null;
                args.put((Object)EL_CATCH, childObject);
                continue;
            }
            if (EL_FINALLY.equals(localName)) {
                if (finallyFound) {
                    parserContext.getReaderContext().error("only a single 'finally' element allowed", (Object)element);
                    return null;
                }
                finallyFound = true;
                singleActionDefinition = null;
                args.put((Object)EL_FINALLY, childObject);
                continue;
            }
            if ("action".equals(localName)) {
                if (catchFound || finallyFound) {
                    parserContext.getReaderContext().error("'action' not allowed after 'catch' or 'finally'", (Object)element);
                    return null;
                }
                if (singleActionDefinition == null && actions.isEmpty()) {
                    if (childObject instanceof BeanDefinitionHolder && ((BeanDefinitionHolder)childObject).getBeanDefinition() instanceof AbstractBeanDefinition) {
                        singleActionDefinition = (AbstractBeanDefinition)((BeanDefinitionHolder)childObject).getBeanDefinition();
                    }
                } else {
                    singleActionDefinition = null;
                }
                actions.add(childObject);
                continue;
            }
            parserContext.getReaderContext().error("element '" + localName + "' not supported in '" + element.getLocalName() + "'", (Object)element);
        }
        Map map = parserContext.getDelegate().parseMapElement(element, (BeanDefinition)builder.getBeanDefinition());
        if ("action".equals(element.getLocalName()) && !StringTools.isEmpty((String)(id = element.getAttribute("id")))) {
            map.put("id", id);
        }
        if (singleActionDefinition == null || map.size() > 0) {
            args.putAll(map);
            return builder.getBeanDefinition();
        }
        return singleActionDefinition;
    }

    public static AbstractBeanDefinition parseActionSpecInline(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = ActionBeanDefinitionParser.createActionSpecBuilder(null);
        String actionRef = element.getAttribute("ref");
        if (!StringTools.isEmpty((String)actionRef)) {
            builder.addPropertyValue("ref", (Object)actionRef);
            return builder.getBeanDefinition();
        }
        String actionFactory = element.getAttribute(ATTR_DO);
        if (StringTools.isEmpty((String)actionFactory) && StringTools.isEmpty((String)(actionFactory = element.getAttribute("action")))) {
            parserContext.getReaderContext().error("either 'ref' or 'do' attribute required in '" + element.getLocalName() + "'", (Object)element);
            return null;
        }
        builder.addPropertyValue("factory", (Object)actionFactory);
        Map map = parserContext.getDelegate().parseMapElement(element, (BeanDefinition)builder.getBeanDefinition());
        builder.addPropertyValue("args", (Object)map);
        List children = DomUtils.getChildElementsByTagName((Element)element, (String[])new String[]{"action", EL_CATCH, EL_FINALLY});
        if (!children.isEmpty()) {
            parserContext.getReaderContext().error("inlined action in '" + element.getLocalName() + "' cannot contain 'action', 'catch' or 'finally' elements", (Object)element);
            return null;
        }
        return builder.getBeanDefinition();
    }

    public static AbstractBeanDefinition parseActionSpecStatement(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = ActionBeanDefinitionParser.createActionSpecBuilder(element);
        String actionRef = element.getAttribute("ref");
        if (!StringTools.isEmpty((String)actionRef)) {
            builder.addPropertyValue("ref", (Object)actionRef);
            return builder.getBeanDefinition();
        }
        String actionFactory = element.getAttribute("factory");
        if (StringTools.isEmpty((String)actionFactory)) {
            parserContext.getReaderContext().error("either 'ref' or 'factory' attribute required in '" + element.getLocalName() + "'", (Object)element);
            return null;
        }
        builder.addPropertyValue("factory", (Object)actionFactory);
        Map map = parserContext.getDelegate().parseMapElement(element, (BeanDefinition)builder.getBeanDefinition());
        builder.addPropertyValue("args", (Object)map);
        String id = element.getAttribute("id");
        if (!StringTools.isEmpty((String)id)) {
            map.put("id", id);
        }
        for (Element child : DomUtils.getChildElements((Element)element)) {
            if ("entry".equals(child.getLocalName())) continue;
            parserContext.getReaderContext().error("action '" + element.getLocalName() + "' cannot contain '" + child.getLocalName() + "'", (Object)element);
            return null;
        }
        List children = DomUtils.getChildElementsByTagName((Element)element, (String[])new String[]{"action", EL_CATCH, EL_FINALLY});
        if (!children.isEmpty()) {
            parserContext.getReaderContext().error("inlined action '" + element.getLocalName() + "' cannot contain 'action', 'catch' or 'finally' elements", (Object)element);
            return null;
        }
        return builder.getBeanDefinition();
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        if (element.hasAttribute("factory") || element.hasAttribute("ref")) {
            return ActionBeanDefinitionParser.parseActionSpecStatement(element, parserContext);
        }
        return ActionBeanDefinitionParser.parseActionSpecBlock(element, parserContext, parserContext.getContainingBeanDefinition());
    }
}

