/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.schema.widget;

import de.intarsys.spring.schema.widget.ActionBeanDefinitionParser;
import de.intarsys.tools.string.StringTools;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class WidgetBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected Class getBeanClass(Element element) {
        try {
            return Class.forName("de.intarsys.widget.model.WidgetDefinition");
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    protected void parseAttribute(Element element, BeanDefinitionBuilder builder, String elementName, String propertyName) {
        Attr node = element.getAttributeNode(elementName);
        if (node != null) {
            String value = node.getValue();
            builder.addPropertyValue(propertyName == null ? elementName : propertyName, (Object)value);
        }
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        return this.parseInternalWidget(element, parserContext);
    }

    protected void parseInternalCallback(Map<String, Object> map, Element element, ParserContext parserContext, BeanDefinition bd) {
        String event = element.getAttribute("event");
        if (StringTools.isEmpty((String)event)) {
            event = "select";
        }
        String actionDo = element.getAttribute("do");
        String actionAction = element.getAttribute("action");
        String actionRef = element.getAttribute("ref");
        AbstractBeanDefinition actionDefinition = !StringTools.isEmpty((String)actionDo) ? ActionBeanDefinitionParser.parseActionSpecInline(element, parserContext) : (!StringTools.isEmpty((String)actionAction) ? ActionBeanDefinitionParser.parseActionSpecInline(element, parserContext) : (!StringTools.isEmpty((String)actionRef) ? ActionBeanDefinitionParser.parseActionSpecInline(element, parserContext) : ActionBeanDefinitionParser.parseActionSpecBlock(element, parserContext, bd)));
        map.put(event, actionDefinition);
    }

    protected void parseInternalProperty(Map<String, Object> map, Element element) {
        String name = element.getAttribute("name");
        String value = element.getAttribute("value");
        map.put(name, value);
    }

    protected AbstractBeanDefinition parseInternalWidget(Element element, ParserContext parserContext) {
        List onElements;
        List propElements;
        Element iconElement;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((Class)this.getBeanClass(element));
        this.parseAttribute(element, builder, "id", null);
        this.parseAttribute(element, builder, "type", null);
        this.parseAttribute(element, builder, "parent", "parentName");
        this.parseAttribute(element, builder, "label", null);
        this.parseAttribute(element, builder, "tip", null);
        this.parseAttribute(element, builder, "description", null);
        Element labelElement = DomUtils.getChildElementByTagName((Element)element, (String)"label");
        if (labelElement != null) {
            Object label = parserContext.getDelegate().parsePropertySubElement(labelElement, (BeanDefinition)builder.getBeanDefinition());
            builder.addPropertyValue("labelRaw", label);
        }
        if ((iconElement = DomUtils.getChildElementByTagName((Element)element, (String)"icon")) == null) {
            this.parseAttribute(element, builder, "icon", "iconName");
        } else {
            Object icon = parserContext.getDelegate().parsePropertySubElement(iconElement, (BeanDefinition)builder.getBeanDefinition());
            builder.addPropertyValue("icon", icon);
        }
        this.parseAttribute(element, builder, "register", "registerName");
        List widgetElements = DomUtils.getChildElementsByTagName((Element)element, (String)"widget");
        if (!widgetElements.isEmpty()) {
            ManagedList children = new ManagedList(widgetElements.size());
            for (Object widgetElement : widgetElements) {
                children.add((Object)this.parseInternalWidget((Element)widgetElement, parserContext));
            }
            builder.addPropertyValue("children", (Object)children);
        }
        if (!(propElements = DomUtils.getChildElementsByTagName((Element)element, (String)"property")).isEmpty()) {
            ManagedMap properties = new ManagedMap(propElements.size());
            for (Element propElement : propElements) {
                this.parseInternalProperty((Map<String, Object>)properties, propElement);
            }
            builder.addPropertyValue("properties", (Object)properties);
        }
        if (!(onElements = DomUtils.getChildElementsByTagName((Element)element, (String)"on")).isEmpty()) {
            ManagedMap children = new ManagedMap(onElements.size());
            for (Element onElement : onElements) {
                this.parseInternalCallback((Map<String, Object>)children, onElement, parserContext, (BeanDefinition)builder.getBeanDefinition());
            }
            builder.addPropertyValue("callbacks", (Object)children);
        }
        return builder.getBeanDefinition();
    }
}

