/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.jaxrs.exception.DtoError;
import de.intarsys.tools.jaxrs.exception.ResponseError;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.LiteralMessage;
import de.intarsys.tools.observation.api.Observation;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

public class ApiForbiddenAccessDeniedHandler
implements AccessDeniedHandler,
AuthenticationEntryPoint {
    private static final String HTTP_HEADER_CONTENT_TYPE = "content-type";
    private static final String ERR_FORBIDDEN = "Forbidden";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger Log = LoggerFactory.getLogger(ApiForbiddenAccessDeniedHandler.class);

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        this.process(request, response, (Exception)exception);
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException exception) throws IOException, ServletException {
        this.process(request, response, (Exception)exception);
    }

    protected void process(HttpServletRequest request, HttpServletResponse response, Exception exception) throws IOException {
        Log.trace("{} reply FORBIDDEN ({})", (Object)this, (Object)ExceptionTools.getMessage((Throwable)exception));
        IMessage msg = LiteralMessage.create((String)"failed", (String)"authorization failed", (Object[])new Object[0]);
        String path = request.getRequestURI();
        Observation.builder().source("authorization").put("resourceType", (Object)"Service").put("resourceId", (Object)path).put("operationId", (Object)"execute").message(msg).build().publish();
        response.setStatus(403);
        response.setHeader(HTTP_HEADER_CONTENT_TYPE, "application/json");
        ResponseError error = new ResponseError();
        DtoError detail = new DtoError();
        detail.setCode(ERR_FORBIDDEN);
        detail.setMessage("Accessing " + path + " is forbidden");
        error.setError(detail);
        MAPPER.writeValue((OutputStream)response.getOutputStream(), (Object)error);
        response.flushBuffer();
    }
}

