/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.intarsys.tools.jaxrs.exception.DtoError;
import de.intarsys.tools.jaxrs.exception.ResponseError;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.LiteralMessage;
import de.intarsys.tools.observation.api.Observation;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class ApiUnauthorizedAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    private static final String ERR_UNAUTHORIZED = "Unauthorized";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger Log = LoggerFactory.getLogger(ApiUnauthorizedAuthenticationEntryPoint.class);

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        Log.trace("{} reply UNAUTHORIZED", (Object)this);
        IMessage msg = LiteralMessage.create((String)"failed", (String)"authorization failed", (Object[])new Object[0]);
        String path = request.getRequestURI();
        Observation.builder().source("authorization").put("resourceType", (Object)"Service").put("resourceId", (Object)path).put("operationId", (Object)"execute").message(msg).build().publish();
        response.setStatus(401);
        response.setHeader("WWW-Authenticate", "API");
        response.setHeader("content-type", "application/json");
        ResponseError error = new ResponseError();
        DtoError detail = new DtoError();
        detail.setCode(ERR_UNAUTHORIZED);
        detail.setMessage("Accessing " + path + " is not authorized");
        error.setError(detail);
        MAPPER.writeValue((OutputStream)response.getOutputStream(), (Object)error);
        response.flushBuffer();
    }
}

