/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.security;

import de.intarsys.tools.string.StringTools;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoders;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;

public class JwtDecoderFactoryBean
implements FactoryBean<JwtDecoder> {
    private String jwkSetUri;
    private String issuerUri;
    private String signatureAlgorithm;
    private String macAlgorithm;
    private String publicKey;
    private String secretKey;

    public String getIssuerUri() {
        return this.issuerUri;
    }

    public String getJwkSetUri() {
        return this.jwkSetUri;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public JwtDecoder getObject() throws Exception {
        NimbusJwtDecoder.JwkSetUriJwtDecoderBuilder builder;
        NimbusJwtDecoder decoder = null;
        if (!StringTools.isEmpty((String)this.getJwkSetUri())) {
            builder = NimbusJwtDecoder.withJwkSetUri((String)this.jwkSetUri);
            if (!StringTools.isEmpty((String)this.getSignatureAlgorithm())) {
                builder.jwsAlgorithm(SignatureAlgorithm.from((String)this.getSignatureAlgorithm()));
            }
            decoder = builder.build();
        }
        if (!StringTools.isEmpty((String)this.getPublicKey())) {
            builder = NimbusJwtDecoder.withPublicKey(null);
            if (!StringTools.isEmpty((String)this.getSignatureAlgorithm())) {
                builder.signatureAlgorithm(SignatureAlgorithm.from((String)this.getSignatureAlgorithm()));
            }
            decoder = builder.build();
        }
        if (!StringTools.isEmpty((String)this.getSecretKey())) {
            builder = NimbusJwtDecoder.withSecretKey(null);
            if (!StringTools.isEmpty((String)this.getSignatureAlgorithm())) {
                builder.macAlgorithm(MacAlgorithm.from((String)this.getMacAlgorithm()));
            }
            decoder = builder.build();
        }
        if (decoder == null) {
            return JwtDecoders.fromIssuerLocation((String)this.getIssuerUri());
        }
        OAuth2TokenValidator validators = StringTools.isEmpty((String)this.getIssuerUri()) ? JwtValidators.createDefault() : JwtValidators.createDefaultWithIssuer((String)this.getIssuerUri());
        decoder.setJwtValidator(validators);
        return decoder;
    }

    public Class<?> getObjectType() {
        return JwtDecoder.class;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setIssuerUri(String issuerUri) {
        this.issuerUri = issuerUri;
    }

    public void setJwkSetUri(String jwkSetUri) {
        this.jwkSetUri = jwkSetUri;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }
}

