/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.security;

import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class JwtGrantedAuthoritiesByRolesConverter
implements Converter<Jwt, Collection<GrantedAuthority>> {
    private static final String DEFAULT_AUTHORITY_PREFIX = "ROLE_";
    private static final String CLAIM_REALM_ACCESS_ROLES = "realm_access.roles";
    private String authorityPrefix = "ROLE_";
    private String authoritiesClaimName = "realm_access.roles";
    private boolean authorityToUpperCase;
    private boolean authorityToLowerCase;

    public Collection<GrantedAuthority> convert(Jwt jwt) {
        ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
        for (String authority : this.getAuthorities(jwt)) {
            if (this.isAuthorityToUpperCase()) {
                authority = authority.toUpperCase();
            } else if (this.isAuthorityToLowerCase()) {
                authority = authority.toLowerCase();
            }
            String name = this.authorityPrefix + authority;
            grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(name));
        }
        return grantedAuthorities;
    }

    private Collection<String> getAuthorities(Jwt jwt) {
        String claimName = this.getAuthoritiesClaimName(jwt);
        if (StringTools.isEmpty((String)claimName)) {
            return Collections.emptyList();
        }
        String[] path = claimName.split("\\.");
        Object authorities = jwt.getClaim(path[0]);
        for (int i = 1; i < path.length; ++i) {
            if (!(authorities instanceof Map)) {
                return Collections.emptyList();
            }
            Map currrentMap = (Map)authorities;
            authorities = currrentMap.get(path[i]);
        }
        if (authorities instanceof String) {
            if (StringUtils.hasText((String)((String)authorities))) {
                return Arrays.asList(((String)authorities).split(" "));
            }
            return Collections.emptyList();
        }
        if (authorities instanceof Collection) {
            return (Collection)authorities;
        }
        return Collections.emptyList();
    }

    public String getAuthoritiesClaimName(Jwt jwt) {
        return this.authoritiesClaimName;
    }

    public boolean isAuthorityToLowerCase() {
        return this.authorityToLowerCase;
    }

    public boolean isAuthorityToUpperCase() {
        return this.authorityToUpperCase;
    }

    public void setAuthoritiesClaimName(String authoritiesClaimName) {
        Assert.hasText((String)authoritiesClaimName, (String)"authoritiesClaimName cannot be empty");
        this.authoritiesClaimName = authoritiesClaimName;
    }

    public void setAuthorityPrefix(String authorityPrefix) {
        Assert.hasText((String)authorityPrefix, (String)"authorityPrefix cannot be empty");
        this.authorityPrefix = authorityPrefix;
    }

    public void setAuthorityToLowerCase(boolean authorityToLowerCase) {
        this.authorityToLowerCase = authorityToLowerCase;
    }

    public void setAuthorityToUpperCase(boolean authorityToUpperCase) {
        this.authorityToUpperCase = authorityToUpperCase;
    }
}

