/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.security;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.BearerTokenErrors;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.util.StringUtils;

public final class LenientBearerTokenResolver
implements BearerTokenResolver {
    private boolean allowFormEncodedBodyParameter = false;
    private boolean allowUriQueryParameter = false;
    private String bearerTokenHeaderName = "Authorization";

    private static String resolveFromRequestParameters(HttpServletRequest request) {
        String[] values = request.getParameterValues("access_token");
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        BearerTokenError error = BearerTokenErrors.invalidRequest((String)"Found multiple bearer tokens in the request");
        throw new OAuth2AuthenticationException((OAuth2Error)error);
    }

    private boolean isParameterTokenEnabledForRequest(HttpServletRequest request) {
        return this.allowFormEncodedBodyParameter && "POST".equals(request.getMethod()) && "application/x-www-form-urlencoded".equals(request.getContentType()) || this.allowUriQueryParameter && "GET".equals(request.getMethod());
    }

    private boolean isParameterTokenSupportedForRequest(HttpServletRequest request) {
        return "POST".equals(request.getMethod()) && "application/x-www-form-urlencoded".equals(request.getContentType()) || "GET".equals(request.getMethod());
    }

    public String resolve(HttpServletRequest request) {
        String parameterToken;
        String authorizationHeaderToken = this.resolveFromAuthorizationHeader(request);
        String string = parameterToken = this.isParameterTokenSupportedForRequest(request) ? LenientBearerTokenResolver.resolveFromRequestParameters(request) : null;
        if (authorizationHeaderToken != null) {
            if (parameterToken != null) {
                BearerTokenError error = BearerTokenErrors.invalidRequest((String)"Found multiple bearer tokens in the request");
                throw new OAuth2AuthenticationException((OAuth2Error)error);
            }
            return authorizationHeaderToken;
        }
        if (parameterToken != null && this.isParameterTokenEnabledForRequest(request)) {
            return parameterToken;
        }
        return null;
    }

    private String resolveFromAuthorizationHeader(HttpServletRequest request) {
        String authorization = request.getHeader(this.bearerTokenHeaderName);
        if (!StringUtils.startsWithIgnoreCase((String)authorization, (String)"bearer")) {
            return null;
        }
        return authorization.substring(6).trim();
    }

    public void setAllowFormEncodedBodyParameter(boolean allowFormEncodedBodyParameter) {
        this.allowFormEncodedBodyParameter = allowFormEncodedBodyParameter;
    }

    public void setAllowUriQueryParameter(boolean allowUriQueryParameter) {
        this.allowUriQueryParameter = allowUriQueryParameter;
    }

    public void setBearerTokenHeaderName(String bearerTokenHeaderName) {
        this.bearerTokenHeaderName = bearerTokenHeaderName;
    }
}

