/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.security;

import de.intarsys.aaa.authenticate.api.IAuthentication;
import de.intarsys.aaa.authenticate.api.IAuthenticationProvider;
import de.intarsys.aaa.authenticate.api.IAuthority;
import de.intarsys.aaa.authenticate.impl.CommonAuthentication;
import java.util.Collection;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class SpringAuthenticationProvider
implements IAuthenticationProvider {
    public IAuthentication getAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return new SpringAuthentication(authentication);
    }

    public void setAuthentication(IAuthentication state) {
        if (state == null) {
            SecurityContextHolder.getContext().setAuthentication(null);
        } else if (state instanceof SpringAuthentication) {
            SecurityContextHolder.getContext().setAuthentication(((SpringAuthentication)state).getAuthentication());
        } else {
            throw new IllegalArgumentException("SpringAuthentication expected");
        }
    }

    static class SpringAuthentication
    extends CommonAuthentication {
        private final Authentication authentication;

        public SpringAuthentication(Authentication authentication) {
            this.authentication = authentication;
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public Collection<? extends IAuthority> getAuthorities() {
            return this.authentication.getAuthorities().stream().map(auth -> new SpringAuthority((GrantedAuthority)auth)).toList();
        }

        public boolean isAuthenticated() {
            return this.authentication != null && this.authentication.isAuthenticated();
        }
    }

    static class SpringAuthority
    implements IAuthority {
        private final GrantedAuthority authority;

        public SpringAuthority(GrantedAuthority authority) {
            this.authority = authority;
        }

        public String getId() {
            return this.authority.getAuthority();
        }
    }
}

