/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.security;

import de.intarsys.spring.security.StaticAuthenticationToken;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class StaticAuthenticationFilter
extends OncePerRequestFilter {
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private List<SimpleGrantedAuthority> authorities;
    private Object principal = "static";

    protected boolean authenticationIsRequired() {
        return true;
    }

    protected Authentication createAuthentication(HttpServletRequest request) {
        StaticAuthenticationToken auth = new StaticAuthenticationToken(this.principal, this.getAuthorities());
        auth.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        return auth;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (this.authenticationIsRequired()) {
            Authentication authentication = this.createAuthentication(request);
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public AuthenticationDetailsSource<HttpServletRequest, ?> getAuthenticationDetailsSource() {
        return this.authenticationDetailsSource;
    }

    public List<SimpleGrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        Assert.notNull(authenticationDetailsSource, (String)"AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setAuthorities(List<SimpleGrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    public void setPrincipal(Object principal) {
        this.principal = principal;
    }
}

