/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.security.scim;

import com.fasterxml.jackson.jakarta.rs.json.JacksonXmlBindJsonProvider;
import de.intarsys.tools.jaxrs.logging.LoggingFeature;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionAuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.util.Assert;

public class OpaqueScimTokenIntrospector
implements OpaqueTokenIntrospector {
    private static final String CLAIM_SCIM = "scim";
    private final Logger Log = LoggerFactory.getLogger(OpaqueScimTokenIntrospector.class);
    private String introspectionUri;
    private Client client;
    private HostnameVerifier hostnameVerifier;
    private SSLContext sslContext;
    private Converter<Map<String, Object>, Collection<GrantedAuthority>> grantedAuthoritiesConverter;

    public OpaqueScimTokenIntrospector(String introspectionUri) {
        Assert.notNull((Object)introspectionUri, (String)"introspectionUri cannot be null");
        this.introspectionUri = introspectionUri;
    }

    protected OAuth2AuthenticatedPrincipal convertClaimsSet(Map<String, Object> scimData) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        Instant issueTime = Instant.now();
        Instant expireTime = issueTime.plus(5L, ChronoUnit.MINUTES);
        claims.put("iss", this.getIntrospectionUri());
        claims.put("exp", expireTime);
        claims.put("iat", issueTime);
        claims.put("nbf", issueTime);
        claims.put("jti", UUID.randomUUID().toString());
        claims.put("sub", scimData.get("id"));
        claims.put(CLAIM_SCIM, scimData);
        claims.putAll(scimData);
        Collection<Object> authorities = this.getGrantedAuthoritiesConverter() == null ? Collections.emptyList() : (Collection)this.getGrantedAuthoritiesConverter().convert(scimData);
        return new OAuth2IntrospectionAuthenticatedPrincipal(claims, authorities);
    }

    protected Client createClient() {
        ClientBuilder builder = ClientBuilder.newBuilder();
        if (this.getSslContext() != null) {
            builder.sslContext(this.getSslContext());
        }
        if (this.getHostnameVerifier() != null) {
            builder.hostnameVerifier(this.getHostnameVerifier());
        }
        return (Client)((Client)builder.build().register((Object)new JacksonXmlBindJsonProvider())).register((Object)new LoggingFeature(this.Log, Level.DEBUG, LoggingFeature.Verbosity.PAYLOAD_TEXT, Integer.valueOf(10000)));
    }

    protected Client getClient() {
        if (this.client == null) {
            this.client = this.createClient();
        }
        return this.client;
    }

    public Converter<Map<String, Object>, Collection<GrantedAuthority>> getGrantedAuthoritiesConverter() {
        return this.grantedAuthoritiesConverter;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public String getIntrospectionUri() {
        return this.introspectionUri;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void initialize() {
        this.client = this.createClient();
    }

    public OAuth2AuthenticatedPrincipal introspect(String token) {
        Map<String, Object> scimData = this.validateToken(token);
        return this.convertClaimsSet(scimData);
    }

    protected WebTarget introspectionTarget() {
        return this.getClient().target(this.getIntrospectionUri());
    }

    public void setGrantedAuthoritiesConverter(Converter<Map<String, Object>, Collection<GrantedAuthority>> grantedAuthoritiesConverter) {
        this.grantedAuthoritiesConverter = grantedAuthoritiesConverter;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    protected Map<String, Object> validateToken(String token) {
        WebTarget target = this.introspectionTarget();
        Invocation.Builder builder = target.request().header("Authorization", (Object)("Bearer " + token));
        Response response = builder.get();
        if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
            return (Map)response.readEntity(Map.class);
        }
        throw new OAuth2IntrospectionException("error " + response.getStatus() + " calling introspection endpoint '" + target.getUri() + "', " + response.getStatusInfo().getReasonPhrase());
    }
}

