/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.security.scim;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public final class ScimGrantedAuthoritiesByGroupsConverter
implements Converter<Map<String, Object>, Collection<GrantedAuthority>> {
    private static final String DEFAULT_GROUP_PREFIX = "GROUP_";
    private String groupPrefix = "GROUP_";
    private boolean groupToUpperCase;
    private boolean groupToLowerCase;

    public Collection<GrantedAuthority> convert(Map<String, Object> scimData) {
        List groups = (List)scimData.get("groups");
        return groups.stream().map(g -> g.get("display")).map(String.class::cast).map(group -> {
            if (this.isGroupToUpperCase()) {
                group = group.toUpperCase();
            } else if (this.isGroupToLowerCase()) {
                group = group.toLowerCase();
            }
            return this.getGroupPrefix() + group;
        }).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    public String getGroupPrefix() {
        return this.groupPrefix;
    }

    public boolean isGroupToLowerCase() {
        return this.groupToLowerCase;
    }

    public boolean isGroupToUpperCase() {
        return this.groupToUpperCase;
    }

    public void setGroupPrefix(String groupPrefix) {
        this.groupPrefix = groupPrefix;
    }

    public void setGroupToLowerCase(boolean groupToLowerCase) {
        this.groupToLowerCase = groupToLowerCase;
    }

    public void setGroupToUpperCase(boolean groupToUpperCase) {
        this.groupToUpperCase = groupToUpperCase;
    }
}

