/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.tools;

import de.intarsys.spring.tools.IPathCanonicalizer;

public class PathCanonicalizer
implements IPathCanonicalizer {
    private boolean canonicalizeDash = false;
    private boolean canonicalizeUnderscore = false;
    private boolean canonicalizeCase = false;

    public PathCanonicalizer() {
    }

    public PathCanonicalizer(boolean canonicalizeDash, boolean canonicalizeUnderscore, boolean canonicalizeCase) {
        this.canonicalizeDash = canonicalizeDash;
        this.canonicalizeUnderscore = canonicalizeUnderscore;
        this.canonicalizeCase = canonicalizeCase;
    }

    @Override
    public String canonicalize(String path) {
        String result = path;
        if (this.canonicalizeDash) {
            result = result.replace("-", "");
        }
        if (this.canonicalizeUnderscore) {
            result = result.replace("_", ".");
        }
        if (this.canonicalizeCase) {
            result = result.toLowerCase();
        }
        return result;
    }

    public boolean isCanonicalizeCase() {
        return this.canonicalizeCase;
    }

    public boolean isCanonicalizeDash() {
        return this.canonicalizeDash;
    }

    public boolean isCanonicalizeUnderscore() {
        return this.canonicalizeUnderscore;
    }

    public void setCanonicalizeCase(boolean canonicalizeCase) {
        this.canonicalizeCase = canonicalizeCase;
    }

    public void setCanonicalizeDash(boolean canonicalizeDash) {
        this.canonicalizeDash = canonicalizeDash;
    }

    public void setCanonicalizeUnderscore(boolean canonicalizeUnderscore) {
        this.canonicalizeUnderscore = canonicalizeUnderscore;
    }
}

