/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.tools;

import de.intarsys.tools.servicelocator.IServiceResolver;
import de.intarsys.tools.servicelocator.ServiceCreationException;
import de.intarsys.tools.servicelocator.ServiceLocator;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ServiceResolverSpring<T>
implements IServiceResolver<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConfigurableApplicationContext applicationContext;

    public ServiceResolverSpring(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public T apply(Class<T> lookupClass) {
        this.log.trace("ServiceResolver {} resolve {}", (Object)this, lookupClass);
        if (!this.applicationContext.isActive()) {
            return null;
        }
        try {
            return (T)this.applicationContext.getBean(lookupClass);
        }
        catch (NoUniqueBeanDefinitionException e) {
            throw new ServiceCreationException("service creation for " + lookupClass + " not unique", (Throwable)e);
        }
        catch (NoSuchBeanDefinitionException e) {
            return null;
        }
        catch (Exception e) {
            throw new ServiceCreationException("service creation for " + lookupClass + " failed", (Throwable)e);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @PostConstruct
    public void init() {
        ServiceLocator.get().addResolver((IServiceResolver)this);
    }
}

