/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.webmvc;

import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.servlet.common.ServletTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.resource.PathResourceResolver;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.TransformedResource;

public class AngularAppHttpRequestHandler
extends ResourceHttpRequestHandler {
    private String staticPath;
    private final List<Resource> overrideLocations = new ArrayList<Resource>();
    private String appName;
    private String appPath;

    public void addOverrideLocation(Resource overrideLocation) {
        this.overrideLocations.add(overrideLocation);
    }

    public void afterPropertiesSet() throws Exception {
        String tmpPath = PathTools.join((String[])new String[]{"classpath:/static/", this.getStaticPath()});
        ArrayList<Resource> locations = new ArrayList<Resource>();
        locations.addAll(this.getOverrideLocations());
        ApplicationContext applicationContext = this.obtainApplicationContext();
        locations.add(applicationContext.getResource(tmpPath));
        this.setLocations(locations);
        this.setResourceResolvers(Arrays.asList(new PathResourceResolver(){

            protected Resource getResource(String resourcePath, Resource location) throws IOException {
                if (!resourcePath.contains(".")) {
                    resourcePath = "index.html";
                }
                return super.getResource(resourcePath, location);
            }
        }));
        ArrayList<ResourceTransformer> resourceTransformers = new ArrayList<ResourceTransformer>(this.getResourceTransformers());
        resourceTransformers.add(this::transformNgIndex);
        this.setResourceTransformers(resourceTransformers);
        super.afterPropertiesSet();
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public List<Resource> getOverrideLocations() {
        return new ArrayList<Resource>(this.overrideLocations);
    }

    public String getStaticPath() {
        if (StringTools.isEmpty((String)this.staticPath)) {
            return PathTools.withTrailingSeparator((String)this.getAppName());
        }
        return PathTools.withTrailingSeparator((String)this.staticPath);
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setAppPath(String appPath) {
        this.appPath = appPath;
    }

    public void setStaticPath(String path) {
        this.staticPath = path;
    }

    protected Resource transformNgIndex(HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
        String filename = (resource = transformerChain.transform(request, resource)).getFilename();
        if (!"index.html".equals(filename)) {
            return resource;
        }
        String content = StreamTools.getString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        String baseHref = ServletTools.getRequestContextPath((HttpServletRequest)request);
        if (!StringTools.isEmpty((String)this.getAppPath())) {
            baseHref = PathTools.join((String[])new String[]{baseHref, this.getAppPath()});
        }
        baseHref = PathTools.join((String[])new String[]{baseHref, this.getAppName()});
        baseHref = PathTools.withTrailingSeparator((String)baseHref);
        content = content.replaceAll("<base href=\".*\">", "<base href=\"" + baseHref + "\">");
        return new TransformedResource(resource, content.getBytes(StandardCharsets.UTF_8));
    }
}

