/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.spring.webmvc;

import de.intarsys.spring.webmvc.HtmlResourceView;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProviders;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.context.ApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

public class WTFEverythingIsPrivateErrorViewResolver
implements ErrorViewResolver,
Ordered {
    private static final Map<HttpStatus.Series, String> SERIES_VIEWS;
    private ApplicationContext applicationContext;
    private final WebProperties.Resources resources;
    private final TemplateAvailabilityProviders templateAvailabilityProviders;
    private int order = 0x7FFFFFF5;

    public WTFEverythingIsPrivateErrorViewResolver(ApplicationContext applicationContext, WebProperties webProperties) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
        Assert.notNull((Object)webProperties, (String)"WebProperties must not be null");
        this.applicationContext = applicationContext;
        this.resources = webProperties.getResources();
        this.templateAvailabilityProviders = new TemplateAvailabilityProviders(applicationContext);
    }

    WTFEverythingIsPrivateErrorViewResolver(ApplicationContext applicationContext, WebProperties webProperties, TemplateAvailabilityProviders templateAvailabilityProviders) {
        Assert.notNull((Object)applicationContext, (String)"ApplicationContext must not be null");
        Assert.notNull((Object)webProperties, (String)"WebProperties must not be null");
        this.applicationContext = applicationContext;
        this.resources = webProperties.getResources();
        this.templateAvailabilityProviders = templateAvailabilityProviders;
    }

    public int getOrder() {
        return this.order;
    }

    protected ModelAndView resolve(String viewName, Map<String, Object> model) {
        String errorViewName = "error/" + viewName;
        TemplateAvailabilityProvider provider = this.templateAvailabilityProviders.getProvider(errorViewName, this.applicationContext);
        if (provider != null) {
            return new ModelAndView(errorViewName, model);
        }
        return this.resolveResource(errorViewName, model);
    }

    public ModelAndView resolveErrorView(HttpServletRequest request, HttpStatus status, Map<String, Object> model) {
        ModelAndView modelAndView = this.resolve(String.valueOf(status.value()), model);
        if (modelAndView == null && SERIES_VIEWS.containsKey(status.series())) {
            modelAndView = this.resolve(SERIES_VIEWS.get(status.series()), model);
        }
        if (modelAndView == null) {
            modelAndView = this.resolve("error", model);
        }
        return modelAndView;
    }

    protected ModelAndView resolveResource(String viewName, Map<String, Object> model) {
        for (String location : this.resources.getStaticLocations()) {
            try {
                Resource resource = this.applicationContext.getResource(location);
                resource = resource.createRelative(viewName + ".html");
                if (!resource.exists()) continue;
                return new ModelAndView((View)new HtmlResourceView(resource), model);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    static {
        EnumMap<HttpStatus.Series, String> views = new EnumMap<HttpStatus.Series, String>(HttpStatus.Series.class);
        views.put(HttpStatus.Series.CLIENT_ERROR, "4xx");
        views.put(HttpStatus.Series.SERVER_ERROR, "5xx");
        SERIES_VIEWS = Collections.unmodifiableMap(views);
    }
}

