/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.common.api;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.conversation.service.client.api.IntegrationOptions;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.lang.BooleanTools;
import de.intarsys.tools.string.Converter;
import java.util.HashMap;
import java.util.Map;

public final class FlowOptions {
    public static final String AUTO_DISPOSE = "autoDispose";
    public static final String LOGGING = "logging";
    public static final String TRACE = "trace";
    public static final String RESTRICTED_IDENTIFICATION = "restrictedIdentification";
    public static final String PRINCIPAL = "principal";
    public static final String ASYNCH = "asynch";
    public static final String REDIRECT_URI = "redirectUri";
    public static final String LANG = "lang";
    public static final String CLIENT_DATA = "clientData";
    private static final String INTERNAL_CALL = "internalCall";
    private static final Object VALUE_INTERNAL_CALL = new Marker();

    public static Boolean getAutoDispose(IOptionSupport os) {
        if (os == null) {
            return null;
        }
        Object option = os.getOption(AUTO_DISPOSE);
        try {
            return BooleanTools.toBooleanThreeState((Object)option, null);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException("'autoDispose' invalid");
        }
    }

    public static Object getClientData(IOptionSupport os) {
        if (os == null) {
            return null;
        }
        Object option = os.getOption(CLIENT_DATA);
        return option == null ? null : option.toString();
    }

    public static IntegrationOptions getIntegrationOptions(IOptionSupport os) {
        if (os == null) {
            return null;
        }
        IntegrationOptions result = new IntegrationOptions();
        result.setRedirectUri(FlowOptions.getRedirectUri(os));
        result.setAutoDispose(FlowOptions.getAutoDispose(os));
        return result;
    }

    public static String getLang(IOptionSupport os) {
        if (os == null) {
            return null;
        }
        Object option = os.getOption(LANG);
        return option == null ? null : option.toString();
    }

    public static Object getPrincipal(IOptionSupport os) {
        if (os == null) {
            return null;
        }
        return os.getOption(PRINCIPAL);
    }

    public static String getRedirectUri(IOptionSupport os) {
        if (os == null) {
            return null;
        }
        Object option = os.getOption(REDIRECT_URI);
        if (option == null) {
            option = os.getOption("callback");
        }
        return option == null ? null : option.toString();
    }

    public static String getRestrictedIdentification(IOptionSupport os) {
        if (os == null) {
            return null;
        }
        return (String)os.getOption(RESTRICTED_IDENTIFICATION);
    }

    public static boolean isAsynch(IOptionSupport os) {
        if (os == null) {
            return false;
        }
        Object optionValue = os.getOption(ASYNCH);
        if (optionValue == null) {
            return false;
        }
        if (optionValue instanceof Boolean) {
            return (Boolean)optionValue;
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            return Converter.asBoolean((String)optionString, (boolean)false);
        }
        return false;
    }

    public static boolean isInternalCall(IOptionSupport os) {
        if (os == null) {
            return false;
        }
        Object optionValue = os.getOption(INTERNAL_CALL);
        return optionValue == VALUE_INTERNAL_CALL;
    }

    public static boolean isLoggingTrace(IOptionSupport os) {
        if (os == null) {
            return false;
        }
        Object optionValue = os.getOption(LOGGING);
        if (optionValue instanceof Map) {
            Object optionLoggingTrace = ((Map)optionValue).get(TRACE);
            return Converter.asBoolean((String)String.valueOf(optionLoggingTrace), (boolean)false);
        }
        return false;
    }

    public static void setAsynch(IOptionSupport os, boolean value) {
        os.setOption(ASYNCH, value);
    }

    public static void setAutoDispose(IOptionSupport os, Boolean value) {
        os.setOption(AUTO_DISPOSE, value);
    }

    public static void setClientData(IOptionSupport os, Object data) {
        os.setOption(CLIENT_DATA, data);
    }

    public static void setLang(IOptionSupport os, String lang) {
        os.setOption(LANG, lang);
    }

    public static void setLoggingTrace(IOptionSupport os, boolean value) {
        HashMap optionValue = os.getOption(LOGGING);
        if (!(optionValue instanceof Map)) {
            optionValue = new HashMap();
        }
        ((Map)optionValue).put(TRACE, value);
    }

    public static void setPrincipal(IOptionSupport os, Object value) {
        os.setOption(PRINCIPAL, value);
    }

    public static void setRedirectUri(IOptionSupport os, Object value) {
        os.setOption(REDIRECT_URI, value);
    }

    public static void setRestrictedIdentification(IOptionSupport os, String value) {
        os.setOption(RESTRICTED_IDENTIFICATION, value);
    }

    public static void switchInternalCallFalse(IOptionSupport os) {
        os.setOption(INTERNAL_CALL, null);
    }

    public static void switchInternalCallTrue(IOptionSupport os) {
        os.setOption(INTERNAL_CALL, VALUE_INTERNAL_CALL);
    }

    private FlowOptions() {
    }

    public static class Marker
    extends TransientValue {
    }

    @JsonIgnoreType
    public static abstract class TransientValue {
    }
}

