/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.common.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportItem;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportDocumentLocatorContentDeserializer;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportDocumentLocatorContentSerializer;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportDocumentLocatorPathDeserializer;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportItemLocatorHandleDeserializer;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportItemLocatorHandleSerializer;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportItemLocatorPathSerializer;
import de.intarsys.tools.jaxrs.ServiceParam;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;

@ServiceParam
public class TransportDocument
extends TransportItem {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String contentType;
    @JsonSerialize(using=TransportDocumentLocatorContentSerializer.class)
    @JsonDeserialize(using=TransportDocumentLocatorContentDeserializer.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ILocator content;
    @JsonSerialize(using=TransportItemLocatorPathSerializer.class)
    @JsonDeserialize(using=TransportDocumentLocatorPathDeserializer.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ILocator path;
    @JsonSerialize(using=TransportItemLocatorHandleSerializer.class)
    @JsonDeserialize(using=TransportItemLocatorHandleDeserializer.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ILocator handle;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long length;
    @JsonIgnore
    private ILocator locator;

    public static TransportDocumentBuilder builder() {
        return new TransportDocumentBuilder();
    }

    public TransportDocument() {
    }

    public TransportDocument(File content) {
        this.setContent((ILocator)new FileLocator(content));
    }

    public TransportDocument(ILocator content) {
        this.setContent(content);
    }

    public TransportDocument(String name) {
        super(name);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TransportDocument)) {
            return false;
        }
        TransportDocument otherDoc = (TransportDocument)other;
        if (!LangTools.equals((Object)this.locator, (Object)otherDoc.locator)) {
            return false;
        }
        return LangTools.equals((Object)this.getProperties(), (Object)otherDoc.getProperties());
    }

    protected ILocator getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ILocator getHandle() {
        return this.handle;
    }

    public Long getLength() {
        return this.length;
    }

    @Override
    public ILocator getLocator() {
        if (this.locator == null) {
            return new ByteArrayLocator(new byte[0], this.getName());
        }
        return this.locator;
    }

    protected ILocator getPath() {
        return this.path;
    }

    @Override
    public String getType() {
        return "d";
    }

    @Override
    public boolean isDocument() {
        return true;
    }

    @Override
    public boolean isLink() {
        return this.handle != null;
    }

    @Override
    public void setContent(ILocator locator) {
        this.content = locator;
        this.setLocator(locator);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public void setHandle(ILocator locator) {
        this.handle = locator;
        this.setLocator(locator);
        try {
            this.setLength(locator.getLength());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setLength(Long length) {
        this.length = length;
    }

    protected void setLocator(ILocator locator) {
        if (StringTools.isEmpty((String)this.basicGetName()) && locator != null) {
            this.setName(locator.getName());
        }
        this.locator = locator;
    }

    @Override
    public void setPath(ILocator locator) {
        this.path = locator;
        this.setLocator(locator);
    }

    public static class TransportDocumentBuilder
    extends TransportItem.TransportItemBuilder<TransportDocument> {
        protected String contentType;
        protected ILocator content;
        protected ILocator handle;
        protected ILocator path;
        protected Long length;

        @Override
        public TransportDocument build() {
            TransportDocument result = (TransportDocument)super.build();
            if (this.contentType != null) {
                result.setContentType(this.contentType);
            }
            if (this.content != null) {
                result.setContent(this.content);
            }
            if (this.path != null) {
                result.setPath(this.path);
            }
            if (this.handle != null) {
                result.setHandle(this.handle);
            }
            if (this.length != null) {
                result.setLength(this.length);
            }
            return result;
        }

        public TransportDocumentBuilder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public TransportDocumentBuilder content(ILocator content) {
            this.content = content;
            return this;
        }

        @Override
        protected TransportDocument createResult() {
            return new TransportDocument();
        }

        public TransportDocumentBuilder handle(ILocator handle) {
            this.handle = handle;
            return this;
        }

        public TransportDocumentBuilder name(String name) {
            return (TransportDocumentBuilder)super.name(name);
        }

        public TransportDocumentBuilder path(ILocator locator) {
            this.path = locator;
            return this;
        }

        public TransportDocumentBuilder length(Long length) {
            this.length = length;
            return this;
        }

        public TransportDocumentBuilder property(String name, Object value) {
            return (TransportDocumentBuilder)super.property(name, value);
        }
    }
}

