/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jaxrs.filter;

import de.intarsys.com.google.common.base.Stopwatch;
import de.intarsys.com.google.common.io.CountingOutputStream;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionCostProvider
implements WriterInterceptor {
    private static final Logger Log = LoggerFactory.getLogger(ExecutionCostProvider.class);

    public void aroundWriteTo(WriterInterceptorContext writerContext) throws IOException {
        CountingOutputStream outputStream = new CountingOutputStream(writerContext.getOutputStream());
        writerContext.setOutputStream((OutputStream)outputStream);
        Stopwatch sw = Stopwatch.createStarted();
        writerContext.proceed();
        sw.stop();
        long responseCount = outputStream.getCount();
        Log.info("ExecutionCostProvider: size {}, duration {}", (Object)responseCount, (Object)sw.elapsed(TimeUnit.MILLISECONDS));
    }
}

