/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.conversation.service.client.api;

import de.intarsys.tools.string.StringTools;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class IntegrationOptions {
    private String redirectUri;
    private String signalUri;
    private String signalProtocol;
    private Boolean autoDispose;

    public static IntegrationOptions create(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof IntegrationOptions) {
            return (IntegrationOptions)value;
        }
        if (value instanceof String) {
            IntegrationOptions option = new IntegrationOptions();
            option.setRedirectUri((String)value);
            return option;
        }
        throw new IllegalArgumentException();
    }

    public Boolean getAutoDispose() {
        return this.autoDispose;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getRedirectUriEncoded() {
        if (StringTools.isEmpty((String)this.redirectUri)) {
            return null;
        }
        try {
            return URLEncoder.encode(this.redirectUri, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("required encoding");
        }
    }

    public String getSignalProtocol() {
        return this.signalProtocol;
    }

    public String getSignalUri() {
        return this.signalUri;
    }

    public void setAutoDispose(Boolean dispose) {
        this.autoDispose = dispose;
    }

    public void setRedirectUri(String url) {
        this.redirectUri = url;
    }

    public void setSignalProtocol(String signalProtocol) {
        this.signalProtocol = signalProtocol;
    }

    public void setSignalUri(String signalUri) {
        this.signalUri = signalUri;
    }
}

