/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.security.virtualkeystore.db.IPrivateKeyProtection;
import de.intarsys.security.virtualkeystore.db.IWrappedPrivateKey;
import de.intarsys.security.virtualkeystore.db.WrappingPrivateKeyProtection;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.crypto.api.IByteStreamProvider;
import de.intarsys.tools.crypto.api.ICipherFactory;
import de.intarsys.tools.crypto.api.IKeyDerivationFunction;
import de.intarsys.tools.crypto.bytes.PbkdByteProvider;
import de.intarsys.tools.crypto.bytes.StaticByteProvider;
import de.intarsys.tools.crypto.kdf.HashedKeyDerivationFunction;
import de.intarsys.tools.crypto.standard.DerivedKeyCipherFactory;
import de.intarsys.tools.crypto.standard.JcaCipherFactory;
import de.intarsys.tools.hex.HexTools;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;

public class BuiltInPrivateKeyProtectionV1
implements IPrivateKeyProtection {
    private static final String ALG_DEFAULT_V1 = "builtinV1";
    private IPrivateKeyProtection impl = this.createImpl();

    protected IPrivateKeyProtection createImpl() {
        JcaCipherFactory jcaCipherFactory = new JcaCipherFactory();
        jcaCipherFactory.setEncryptionAlgorithmTransformation("AES/CBC/PKCS5Padding");
        jcaCipherFactory.setKeySize(16);
        jcaCipherFactory.init();
        PbkdByteProvider masterBytes = new PbkdByteProvider();
        masterBytes.setIterations(10000);
        masterBytes.setSize(16);
        masterBytes.setPasswordProvider((IByteProvider)new StaticByteProvider("S0meHardC0d3dS3cr3t".getBytes(StandardCharsets.UTF_8)));
        masterBytes.setSaltProvider((IByteProvider)new StaticByteProvider(HexTools.hexStringToBytes((String)"3f635d58321a8b438d9ceefb43dca53b3f635d58321a8b438d9ceefb43dca53b")));
        masterBytes.init();
        HashedKeyDerivationFunction masterKdf = new HashedKeyDerivationFunction();
        masterKdf.setKeyProvider((IByteProvider)masterBytes);
        masterKdf.setSaltProvider((IByteStreamProvider)new StaticByteProvider("JustStorageJustStorageJustStorageJustStorageJustStorage".getBytes(StandardCharsets.UTF_8)));
        masterKdf.init();
        DerivedKeyCipherFactory derivedCipherFactory = new DerivedKeyCipherFactory();
        derivedCipherFactory.setCipherFactory((ICipherFactory)jcaCipherFactory);
        derivedCipherFactory.setKdf((IKeyDerivationFunction)masterKdf);
        derivedCipherFactory.init();
        WrappingPrivateKeyProtection protection = new WrappingPrivateKeyProtection();
        protection.setKeyWrapperFactory((ICipherFactory)derivedCipherFactory);
        protection.setAlgorithm(ALG_DEFAULT_V1);
        return protection;
    }

    @Override
    public PrivateKey decrypt(IWrappedPrivateKey wrappedPrivateKey, Secret password) throws GeneralSecurityException {
        return this.impl.decrypt(wrappedPrivateKey, password);
    }

    @Override
    public IWrappedPrivateKey encrypt(PrivateKey privateKey, Secret password) throws GeneralSecurityException {
        return this.impl.encrypt(privateKey, password);
    }
}

