/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.model.common.file.DBFileSystem;
import de.intarsys.model.common.file.DBNodeRepository;
import de.intarsys.model.common.file.IDBFile;
import de.intarsys.model.common.file.IDBFolder;
import de.intarsys.model.common.file.IDBNode;
import de.intarsys.model.common.security.Certificate;
import de.intarsys.model.common.security.CertificateRepository;
import de.intarsys.model.common.security.Key;
import de.intarsys.model.common.security.KeyRef;
import de.intarsys.model.common.security.KeyRefRepository;
import de.intarsys.model.common.security.KeyRepository;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStore;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreEntry;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreCertificateEntry;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreCertificateToX509CertificateConverter;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreEntry;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreIDEntry;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreTools;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreX509CertificateToCertificateConverter;
import de.intarsys.security.virtualkeystore.db.IPrivateKeyProtection;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.collection.NestedIterator;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.monitor.IMonitor;
import de.intarsys.tools.monitor.MonitorTools;
import jakarta.persistence.EntityManager;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBKeyStore
implements IVirtualKeyStore {
    private static final Logger Log = LoggerFactory.getLogger(DBKeyStore.class);
    private final EntityManager entityManager;
    private final DBNodeRepository nodeRepository;
    private final CertificateRepository certificateRepository;
    private final KeyRepository keyRepository;
    private final KeyRefRepository keyRefRepository;
    private final IMonitor monitor;
    private final IPrivateKeyProtection privateKeyProtection;
    private final EventDispatcher dispatcher;

    public DBKeyStore(EntityManager entityManager, DBNodeRepository nodeRepository, CertificateRepository certificateRepository, KeyRepository keyRepository, KeyRefRepository keyRefRepository, IPrivateKeyProtection privateKeyProtection) {
        this.entityManager = entityManager;
        this.nodeRepository = nodeRepository;
        this.certificateRepository = certificateRepository;
        this.keyRepository = keyRepository;
        this.keyRefRepository = keyRefRepository;
        this.privateKeyProtection = privateKeyProtection;
        this.dispatcher = new EventDispatcher((Object)this);
        this.monitor = MonitorTools.getMonitor((String)DBKeyStore.class.getName());
    }

    public void addEntry(IVirtualKeyStoreEntry entry) {
        this.triggerChanged();
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    public boolean containsAlias(String alias) {
        DBKeyStoreEntry result = DBKeyStoreCertificateEntry.lookup(this, alias);
        if (result != null) {
            return true;
        }
        result = DBKeyStoreIDEntry.lookup(this, alias);
        return result != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVirtualKeyStoreEntry createCertificateEntry(IX509Certificate certificate) throws GeneralSecurityException, IOException {
        Log.trace("Creating keystore certificate entry...");
        this.monitor.attach();
        try {
            Certificate dbCertificate = this.createDBCertificate(certificate);
            DBKeyStoreCertificateEntry entry = new DBKeyStoreCertificateEntry(this, dbCertificate);
            this.getCertificateRepository().save((Object)dbCertificate);
            DBKeyStoreCertificateEntry dBKeyStoreCertificateEntry = entry;
            return dBKeyStoreCertificateEntry;
        }
        finally {
            this.monitor.detach();
        }
    }

    protected Certificate createDBCertificate(IX509Certificate certificate) throws GeneralSecurityException, IOException {
        Certificate dbCertificate = DBKeyStoreTools.createDBCertificate(certificate);
        dbCertificate.setAttribute((Object)DBKeyStoreCertificateToX509CertificateConverter.ATTR_X509CERTIFICATE, (Object)certificate);
        certificate.setAttribute((Object)DBKeyStoreX509CertificateToCertificateConverter.ATTR_DBCERTIFICATE, (Object)dbCertificate);
        return dbCertificate;
    }

    public IVirtualKeyStoreEntry createIDEntry(PrivateKey key, Secret password, IX509PublicKeyCertificate[] certificateChain) throws GeneralSecurityException, IOException {
        Key dbKey = DBKeyStoreTools.createDBKey(key, password, this.getPrivateKeyProtection());
        this.getKeyRepository().save((Object)dbKey);
        return this.createIDEntry(DBKeyStoreTools.createDBKeyRefUri(dbKey), certificateChain);
    }

    public DBKeyStoreIDEntry createIDEntry(String uri, IX509PublicKeyCertificate[] certificateChain) throws GeneralSecurityException, IOException {
        Certificate dbCertificate = this.createDBCertificate((IX509Certificate)certificateChain[0]);
        this.getCertificateRepository().save((Object)dbCertificate);
        KeyRef keyRef = DBKeyStoreTools.createDBKeyRef(uri, dbCertificate);
        this.getKeyRefRepository().save((Object)keyRef);
        return new DBKeyStoreIDEntry(this, keyRef);
    }

    public Iterator<IVirtualKeyStoreEntry> entryIterator() {
        ArrayList<ConversionIterator> iteratorList = new ArrayList<ConversionIterator>();
        List certificates = Certificate.all((EntityManager)this.getEntityManager(), Certificate.class);
        iteratorList.add(new ConversionIterator<Certificate, IVirtualKeyStoreEntry>(certificates.iterator()){

            protected IVirtualKeyStoreEntry createTargetObject(Certificate sourceObject) {
                return new DBKeyStoreCertificateEntry(DBKeyStore.this, sourceObject);
            }
        });
        List keyRefs = KeyRef.all((EntityManager)this.getEntityManager(), KeyRef.class);
        iteratorList.add(new ConversionIterator<KeyRef, IVirtualKeyStoreEntry>(keyRefs.iterator()){

            protected IVirtualKeyStoreEntry createTargetObject(KeyRef sourceObject) {
                return new DBKeyStoreIDEntry(DBKeyStore.this, sourceObject);
            }
        });
        return new NestedIterator(iteratorList);
    }

    public CertificateRepository getCertificateRepository() {
        return this.certificateRepository;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public IVirtualKeyStoreEntry getEntry(String alias) {
        DBKeyStoreEntry result = DBKeyStoreCertificateEntry.lookup(this, alias);
        if (result == null) {
            result = DBKeyStoreIDEntry.lookup(this, alias);
        }
        return result;
    }

    public KeyRefRepository getKeyRefRepository() {
        return this.keyRefRepository;
    }

    public KeyRepository getKeyRepository() {
        return this.keyRepository;
    }

    public DBNodeRepository getNodeRepository() {
        return this.nodeRepository;
    }

    public IPrivateKeyProtection getPrivateKeyProtection() {
        return this.privateKeyProtection;
    }

    public void removeEntry(String alias) {
        throw new UnsupportedOperationException();
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    public int size() {
        return Certificate.count((EntityManager)this.getEntityManager(), Certificate.class) + KeyRef.count((EntityManager)this.getEntityManager(), KeyRef.class);
    }

    public URI storeCopy(ILocator locator) throws IOException {
        EntityManager em = this.getEntityManager();
        byte[] bLocator = LocatorTools.getBytes((ILocator)locator);
        IDBFolder nKeystores = (IDBFolder)DBFileSystem.get().selectByPath(em, "/keystores");
        if (nKeystores == null) {
            nKeystores = DBFileSystem.get().createFolder(em, "/keystores");
        }
        Object name = locator.getName();
        IDBNode nLocator = nKeystores.getNode(em, (String)name);
        int index = 0;
        while (nLocator != null) {
            String basename = LocatorTools.getBaseName((ILocator)locator);
            String extension = LocatorTools.getExtension((ILocator)locator);
            name = basename + "." + index++ + "." + extension;
            nLocator = nKeystores.getNode(em, (String)name);
        }
        IDBFile dbFile = nKeystores.createFile(em, (String)name);
        dbFile.setContent(bLocator);
        String path = dbFile.getPath();
        String rootPrefix = "/de.intarsys.filesystem.root";
        if (path.startsWith(rootPrefix)) {
            path = path.substring(rootPrefix.length());
        }
        try {
            return new URI("db:file", null, path, null);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    protected void triggerChanged() {
        this.dispatcher.triggerChanged(null, null, null);
    }
}

