/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.model.common.security.Certificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreCertificateEntry;
import de.intarsys.security.virtualkeystore.db.DBKeyStore;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreEntry;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreTools;
import de.intarsys.tools.converter.ConversionException;
import jakarta.persistence.EntityManager;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class DBKeyStoreCertificateEntry
extends DBKeyStoreEntry
implements IVirtualKeyStoreCertificateEntry {
    private static final String ALIAS_PREFIX = "certificate_";
    private Certificate dbCertificate;

    public static DBKeyStoreCertificateEntry lookup(DBKeyStore keyStore, String alias) {
        if (alias.startsWith(ALIAS_PREFIX)) {
            int id = Integer.parseInt(alias.substring(ALIAS_PREFIX.length()));
            Certificate certificate = (Certificate)Certificate.lookup((EntityManager)keyStore.getEntityManager(), Certificate.class, (Object)id);
            if (certificate == null) {
                return null;
            }
            return new DBKeyStoreCertificateEntry(keyStore, certificate);
        }
        return null;
    }

    public DBKeyStoreCertificateEntry(DBKeyStore store, Certificate dbCertificate) {
        super(store);
        this.dbCertificate = dbCertificate;
    }

    public String getAlias() {
        return ALIAS_PREFIX + String.valueOf(this.getDBCertificate().getId());
    }

    public IX509Certificate getCertificate() throws IOException, GeneralSecurityException {
        try {
            return DBKeyStoreTools.getX509Certificate(this.getDBCertificate());
        }
        catch (ConversionException e) {
            throw new GeneralSecurityException(e);
        }
    }

    @Override
    public Certificate getDBCertificate() {
        return this.dbCertificate;
    }
}

