/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.model.common.security.Certificate;
import de.intarsys.model.common.security.KeyRef;
import de.intarsys.security.certificate.IServiceType;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.CommonCertificateProvider;
import de.intarsys.security.certificate.common.CommonX509Certificate;
import de.intarsys.security.certificate.filter.CertificateFilterIterator;
import de.intarsys.security.certificate.filter.IServiceTypeSelector;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.privatekey.IPasswordProtectionSupport;
import de.intarsys.security.privatekey.IPrivateKeyProvider;
import de.intarsys.security.virtualkeystore.db.DBKeyStore;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreTools;
import de.intarsys.security.virtualkeystore.db.PACKAGE;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.collection.NullFilterIterator;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.monitor.IMonitor;
import de.intarsys.tools.monitor.MonitorTools;
import de.intarsys.tools.presentation.IPresentationSupport;
import jakarta.persistence.EntityManager;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1OctetString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class DBKeyStoreCertificateProvider
extends CommonCertificateProvider
implements IPresentationSupport,
IPrivateKeyProvider,
IPasswordProtectionSupport {
    private static final Logger Log = LoggerFactory.getLogger(DBKeyStoreCertificateProvider.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final IMonitor monitor = MonitorTools.getMonitor((String)DBKeyStoreCertificateProvider.class.getName());
    private final DBKeyStore dbKeyStore;

    public DBKeyStoreCertificateProvider(DBKeyStore dbKeyStore) {
        this.dbKeyStore = dbKeyStore;
    }

    protected void extendCertificateQuery(StringBuilder from, StringBuilder where, Map<String, Object> parameters, IX509CertificateSelector selector) {
        this.extendCertificateQueryTrusted(from, where, parameters, selector);
        this.extendCertificateQueryPrivateKey(from, where, parameters, selector);
        this.extendCertificateQuerySubject(from, where, parameters, selector);
        this.extendCertificateQuerySubjectKeyIdentifier(from, where, parameters, selector);
        this.extendCertificateQuerySerial(from, where, parameters, selector);
    }

    protected void extendCertificateQueryPrivateKey(StringBuilder from, StringBuilder where, Map<String, Object> parameters, IX509CertificateSelector selector) {
        if (selector.hasPrivateKey() == null) {
            return;
        }
        if (selector.hasPrivateKey().booleanValue()) {
            if (from.indexOf("KeyRef") < 0) {
                from.append(", KeyRef k");
            }
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("k.certificate = c");
        } else {
            where.append("NOT EXISTS (SELECT k FROM KeyRef k WHERE k.certificate = c)");
        }
    }

    protected void extendCertificateQuerySerial(StringBuilder from, StringBuilder where, Map<String, Object> parameters, IX509CertificateSelector selector) {
        if (selector.getSerialNumber() == null) {
            return;
        }
        if (where.length() > 0) {
            where.append(" AND ");
        }
        where.append("c.serial = :serial");
        parameters.put("serial", selector.getSerialNumber().toString());
    }

    protected void extendCertificateQuerySubject(StringBuilder from, StringBuilder where, Map<String, Object> parameters, IX509CertificateSelector selector) {
        if (selector.getSubject() == null) {
            return;
        }
        if (selector.isSubjectMatchStrict()) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("c.subject = :subject");
            parameters.put("subject", selector.getSubject().toString());
        }
    }

    protected void extendCertificateQuerySubjectKeyIdentifier(StringBuilder from, StringBuilder where, Map<String, Object> parameters, IX509CertificateSelector selector) {
        if (selector.getSubjectKeyIdentifier() == null) {
            return;
        }
        try {
            ASN1OctetString octetString = ASN1OctetString.getInstance((Object)ASN1Tools.create((byte[])selector.getSubjectKeyIdentifier()));
            String vKeyId = HexTools.bytesToHexString((byte[])octetString.getOctets());
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append("c.subjectKeyIdentifier = :keyId");
            parameters.put("keyId", vKeyId);
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
    }

    protected void extendCertificateQueryTrusted(StringBuilder from, StringBuilder where, Map<String, Object> parameters, IX509CertificateSelector selector) {
        IServiceTypeSelector serviceTypeSelector = selector.getServiceTypeSelector();
        if (serviceTypeSelector != null) {
            if (where.length() > 0) {
                where.append(" AND");
            }
            if (serviceTypeSelector.isTrustedOnly()) {
                from.append(", ServiceInformation si");
                where.append(" si.certificate = c");
                Set serviceTypes = serviceTypeSelector.getServiceTypes();
                where.append(" AND (");
                boolean firstTerm = true;
                block12: for (IServiceType serviceType : serviceTypes) {
                    if (!firstTerm) {
                        where.append(" OR");
                    }
                    firstTerm = false;
                    switch (serviceType.getUri()) {
                        case "http://uri.intarsys.de/TrstSvc/Svctype/qualifiedsignature": {
                            where.append(" si.type = 'http://uri.etsi.org/TrstSvc/Svctype/CA/QC'");
                            where.append(" OR");
                            where.append(" si.type = 'http://uri.etsi.org/TrstSvc/Svctype/NationalRootCA-QC'");
                            continue block12;
                        }
                        case "http://uri.intarsys.de/TrstSvc/Svctype/qualifiedtimestamp": {
                            where.append(" si.type = 'http://uri.etsi.org/TrstSvc/Svctype/TSA/QTST'");
                            continue block12;
                        }
                        case "http://uri.intarsys.de/TrstSvc/Svctype/trusted": {
                            where.append(" EXISTS (SELECT si FROM ServiceInformation si WHERE si.certificate = c)");
                            continue block12;
                        }
                        case "http://uri.intarsys.de/TrstSvc/Svctype/trustedlist": {
                            where.append(" si.type = 'http://uri.etsi.org/TrstSvc/Svctype/TLIssuer'");
                            continue block12;
                        }
                    }
                    where.append(" si.type = '" + serviceType.getUri() + "'");
                }
                where.append(")");
            } else {
                where.append(" NOT EXISTS (SELECT si FROM ServiceInformation si WHERE si.certificate = c)");
            }
        }
    }

    public DBKeyStore getDbKeyStore() {
        return this.dbKeyStore;
    }

    protected EntityManager getEntityManager() {
        return this.getDbKeyStore().getEntityManager();
    }

    public String getLabel() {
        return Msg.getString("DataBaseCertificateProvider.Label", new Object[0]);
    }

    public PrivateKey getPrivateKey(IX509PublicKeyCertificate certificate, IPasswordProvider passwordProvider) throws UnrecoverableKeyException, IOException {
        KeyRef keyRef = this.lookupKeyRef(certificate);
        Secret password = passwordProvider.getPassword();
        try {
            return DBKeyStoreTools.getPrivateKey(this.getEntityManager(), keyRef, password, this.getDbKeyStore().getPrivateKeyProtection());
        }
        catch (UnrecoverableKeyException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            UnrecoverableKeyException ex = new UnrecoverableKeyException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public String getProviderName() {
        return "BC";
    }

    public boolean hasPrivateKey(IX509PublicKeyCertificate certificate) {
        KeyRef keyRef = this.lookupKeyRef(certificate);
        return keyRef != null;
    }

    public boolean isPrivateKeyPasswordProtected(IX509PublicKeyCertificate certificate) {
        return true;
    }

    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        NullFilterIterator certificates = this.selectCertificates(this.getEntityManager(), filter);
        certificates = new NullFilterIterator(certificates);
        return filter == null ? certificates : new CertificateFilterIterator((Iterator)certificates, filter);
    }

    protected KeyRef lookupKeyRef(IX509PublicKeyCertificate certificate) {
        try {
            Certificate dbCertificate = DBKeyStoreTools.getDBCertificate((IX509Certificate)certificate);
            HashMap<String, Certificate> parameters = new HashMap<String, Certificate>();
            parameters.put("certificate", dbCertificate);
            return (KeyRef)KeyRef.querySingle((EntityManager)this.getEntityManager(), KeyRef.class, parameters);
        }
        catch (ConversionException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator<IX509Certificate> selectCertificates(EntityManager em, IX509CertificateFilter filter) {
        List certificates = null;
        try {
            this.monitor.attach();
            if (filter instanceof IX509CertificateSelector) {
                IX509CertificateSelector selector = (IX509CertificateSelector)filter;
                StringBuilder query = new StringBuilder("SELECT c FROM ");
                StringBuilder from = new StringBuilder("Certificate c");
                StringBuilder where = new StringBuilder("");
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                this.extendCertificateQuery(from, where, parameters, selector);
                query.append((CharSequence)from);
                if (where.length() > 0) {
                    query.append(" WHERE ").append((CharSequence)where);
                }
                Log.trace("Querying certificates: " + query.toString() + " with parameters " + parameters);
                certificates = Certificate.query((EntityManager)em, Certificate.class, (String)query.toString(), parameters);
            } else {
                if (Log.isEnabledForLevel(Level.TRACE)) {
                    Log.trace("Querying all certificates");
                }
                certificates = Certificate.all((EntityManager)em, Certificate.class);
            }
        }
        finally {
            this.monitor.detach();
        }
        return new ConversionIterator<Certificate, IX509Certificate>(certificates.iterator()){

            protected IX509Certificate createTargetObject(Certificate sourceObject) {
                try {
                    IX509Certificate certificate = DBKeyStoreTools.getX509Certificate(sourceObject);
                    if (certificate instanceof CommonX509Certificate) {
                        ((CommonX509Certificate)certificate).setCertificateProvider((ICertificateProvider)DBKeyStoreCertificateProvider.this);
                    }
                    return certificate;
                }
                catch (ConversionException e) {
                    Log.warn(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        };
    }
}

