/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.model.common.security.Certificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreX509CertificateToCertificateConverter;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.IConverter;
import de.intarsys.tools.stream.StreamTools;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.security.cert.CertificateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBKeyStoreCertificateToX509CertificateConverter
implements IConverter<Certificate, IX509Certificate> {
    public static final Attribute ATTR_X509CERTIFICATE = new Attribute("X509Certificate");
    private static final Logger Log = LoggerFactory.getLogger(DBKeyStoreCertificateToX509CertificateConverter.class);

    public IX509Certificate convert(Certificate source) throws ConversionException {
        IX509Certificate certificate = (IX509Certificate)source.getAttribute((Object)ATTR_X509CERTIFICATE);
        if (certificate == null) {
            certificate = this.parseCertificate(source);
            certificate.setAttribute((Object)DBKeyStoreX509CertificateToCertificateConverter.ATTR_DBCERTIFICATE, (Object)source);
            source.setAttribute((Object)ATTR_X509CERTIFICATE, (Object)certificate);
        }
        return certificate;
    }

    public Class<Certificate> getSourceType() {
        return Certificate.class;
    }

    public Class<IX509Certificate> getTargetType() {
        return IX509Certificate.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IX509Certificate parseCertificate(Certificate certificate) {
        if (!Certificate.TYPE_X509.equals(certificate.getType())) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(certificate.getCertificate());
        try {
            IX509Certificate iX509Certificate = X509CertificateFactory.get().createCertificate((InputStream)is);
            return iX509Certificate;
        }
        catch (CertificateException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            IX509Certificate iX509Certificate = null;
            return iX509Certificate;
        }
        finally {
            StreamTools.close((Closeable)is);
        }
    }
}

