/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.model.common.file.DBNodeRepository;
import de.intarsys.model.common.security.CertificateRepository;
import de.intarsys.model.common.security.KeyRefRepository;
import de.intarsys.model.common.security.KeyRepository;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStore;
import de.intarsys.security.virtualkeystore.db.BuiltInPrivateKeyProtectionV1;
import de.intarsys.security.virtualkeystore.db.DBKeyStore;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreCertificateProvider;
import de.intarsys.security.virtualkeystore.db.IPrivateKeyProtection;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DBKeyStoreConfiguration {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private DBNodeRepository nodeRepository;
    @Autowired
    private CertificateRepository certificateRepository;
    @Autowired
    private KeyRepository keyRepository;
    @Autowired
    private KeyRefRepository keyRefRepository;
    @Autowired(required=false)
    @Qualifier(value="dbKeyStorePrivateKeyProtection")
    private IPrivateKeyProtection privateKeyProtection = new BuiltInPrivateKeyProtectionV1();

    @Bean
    public ICertificateProvider certificateProvider() {
        return new DBKeyStoreCertificateProvider((DBKeyStore)this.virtualKeyStore());
    }

    @Bean
    public IVirtualKeyStore virtualKeyStore() {
        return new DBKeyStore(this.entityManager, this.nodeRepository, this.certificateRepository, this.keyRepository, this.keyRefRepository, this.privateKeyProtection);
    }
}

