/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.model.common.file.DBFileSystem;
import de.intarsys.model.common.file.IDBFile;
import de.intarsys.model.common.file.IDBNode;
import de.intarsys.security.virtualkeystore.core.DelegatingResolver;
import de.intarsys.security.virtualkeystore.core.IResolver;
import de.intarsys.security.virtualkeystore.db.ResolverFactory;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import jakarta.persistence.EntityManager;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;

public class DBKeyStoreFileResolver
extends DelegatingResolver {
    private final EntityManager entityManager;

    public DBKeyStoreFileResolver(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public DBKeyStoreFileResolver(EntityManager entityManager, String path) {
        super(path);
        this.entityManager = entityManager;
    }

    protected IResolver createDelegateResolver() throws IOException, GeneralSecurityException {
        URI localUri;
        try {
            localUri = new URI(this.getPath());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        String uriString = localUri.getSchemeSpecificPart();
        String filePath = uriString.substring(0, uriString.indexOf(63));
        IDBNode node = DBFileSystem.get().selectByPath(this.getEntityManager(), filePath);
        if (node == null || !node.isFile()) {
            throw new IOException("node is no file");
        }
        IDBFile file = (IDBFile)node;
        ByteArrayLocator locator = new ByteArrayLocator(file.getContent(), file.getName());
        String query = localUri.getRawQuery();
        return ResolverFactory.create((ILocator)locator, query);
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }
}

