/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.virtualkeystore.db;

import de.intarsys.model.common.security.Certificate;
import de.intarsys.model.common.security.KeyRef;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.virtualkeystore.core.IPrivateKeyResolver;
import de.intarsys.security.virtualkeystore.core.IVirtualKeyStoreIDEntry;
import de.intarsys.security.virtualkeystore.db.DBKeyStore;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreEntry;
import de.intarsys.security.virtualkeystore.db.DBKeyStoreTools;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.crypto.Secret;
import jakarta.persistence.EntityManager;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;

public class DBKeyStoreIDEntry
extends DBKeyStoreEntry
implements IVirtualKeyStoreIDEntry {
    public static final String ALIAS_PREFIX = "key_";
    private KeyRef dbKeyRef;

    public static DBKeyStoreIDEntry lookup(DBKeyStore keyStore, String alias) {
        if (alias.startsWith(ALIAS_PREFIX) && alias.startsWith(ALIAS_PREFIX)) {
            int id = Integer.parseInt(alias.substring(ALIAS_PREFIX.length()));
            KeyRef keyRef = (KeyRef)KeyRef.lookup((EntityManager)keyStore.getEntityManager(), KeyRef.class, (Object)id);
            if (keyRef == null) {
                return null;
            }
            return new DBKeyStoreIDEntry(keyStore, keyRef);
        }
        return null;
    }

    public DBKeyStoreIDEntry(DBKeyStore store, KeyRef keyRef) {
        super(store);
        this.dbKeyRef = keyRef;
    }

    public boolean canExportKey() {
        return true;
    }

    public String getAlias() {
        return ALIAS_PREFIX + String.valueOf(this.getDbKeyRef().getId());
    }

    public IX509Certificate getCertificate() throws IOException, GeneralSecurityException {
        try {
            return DBKeyStoreTools.getX509Certificate(this.getDbKeyRef().getCertificate());
        }
        catch (ConversionException e) {
            throw new GeneralSecurityException(e);
        }
    }

    @Override
    protected Certificate getDBCertificate() {
        return this.getDbKeyRef().getCertificate();
    }

    public KeyRef getDbKeyRef() {
        return this.dbKeyRef;
    }

    public PrivateKey getPrivateKey(Secret password) throws IOException, GeneralSecurityException {
        if (!this.canExportKey()) {
            throw new IllegalStateException("No key available.");
        }
        return DBKeyStoreTools.getPrivateKey(this.getStore().getEntityManager(), this.getDbKeyRef(), password, this.getStore().getPrivateKeyProtection());
    }

    public IPrivateKeyResolver getPrivateKeyResolver() {
        return null;
    }
}

